"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsDataPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _client = require("./client");
var _metrics_data_source = require("./saved_objects/metrics_data_source");
var _kibana_framework_adapter = require("./lib/adapters/framework/kibana_framework_adapter");
var _metrics_explorer = require("./routes/metrics_explorer");
var _metric_indices = require("./routes/metric_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsDataPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "metricsClient", null);
  }
  setup(core) {
    const router = core.http.createRouter();
    const framework = new _kibana_framework_adapter.KibanaFramework(core, router);
    (0, _metrics_explorer.initMetricExplorerRoute)(framework);
    (0, _metric_indices.initMetricIndicesRoute)({
      router,
      metricsClient: new _client.MetricsDataClient()
    });
    core.savedObjects.registerType(_metrics_data_source.metricsDataSourceSavedObjectType);
    this.metricsClient = new _client.MetricsDataClient();
    return {
      client: this.metricsClient
    };
  }
  start() {
    return {};
  }
  stop() {}
}
exports.MetricsDataPlugin = MetricsDataPlugin;