"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrdinalSuffix = getOrdinalSuffix;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getOrdinalSuffix(value) {
  const lastDigit = value % 10;
  if (lastDigit === 1 && value !== 11) {
    return _i18n.i18n.translate('xpack.maps.styles.firstOrdinalSuffix', {
      defaultMessage: 'st'
    });
  }
  if (lastDigit === 2 && value !== 12) {
    return _i18n.i18n.translate('xpack.maps.styles.secondOrdinalSuffix', {
      defaultMessage: 'nd'
    });
  }
  if (lastDigit === 3 && value !== 13) {
    return _i18n.i18n.translate('xpack.maps.styles.thirdOrdinalSuffix', {
      defaultMessage: 'rd'
    });
  }
  return _i18n.i18n.translate('xpack.maps.styles.ordinalSuffix', {
    defaultMessage: 'th'
  });
}