"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSecurityLayerDescriptors = createSecurityLayerDescriptors;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _apmDataView = require("@kbn/apm-data-view");
var _constants = require("../../../../../../common/constants");
var _vector_layer = require("../../../vector_layer");
var _layer_group = require("../../../layer_group");
var _vector_style = require("../../../../styles/vector/vector_style");
var _es_search_source = require("../../../../sources/es_search_source");
var _es_pew_pew_source = require("../../../../sources/es_pew_pew_source");
var _vector_style_defaults = require("../../../../styles/vector/vector_style_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultDynamicProperties = (0, _vector_style_defaults.getDefaultDynamicProperties)();
const euiVisColorPalette = (0, _eui.euiPaletteColorBlind)();
function getSourceField(indexPatternId) {
  return (0, _apmDataView.isAPMDataView)(indexPatternId) ? 'client.geo.location' : 'source.geo.location';
}
function getDestinationField(indexPatternId) {
  return (0, _apmDataView.isAPMDataView)(indexPatternId) ? 'server.geo.location' : 'destination.geo.location';
}
function createSourceLayerDescriptor(indexPatternId, indexPatternTitle, parentId) {
  const sourceDescriptor = _es_search_source.ESSearchSource.createDescriptor({
    indexPatternId,
    geoField: getSourceField(indexPatternId),
    scalingType: _constants.SCALING_TYPES.TOP_HITS,
    topHitsSplitField: (0, _apmDataView.isAPMDataView)(indexPatternId) ? 'client.ip' : 'source.ip',
    tooltipProperties: (0, _apmDataView.isAPMDataView)(indexPatternId) ? ['host.name', 'client.ip', 'client.domain', 'client.geo.country_iso_code', 'client.as.organization.name'] : ['host.name', 'source.ip', 'source.domain', 'source.geo.country_iso_code', 'source.as.organization.name']
  });
  const styleProperties = {
    [_constants.VECTOR_STYLES.FILL_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: euiVisColorPalette[1]
      }
    },
    [_constants.VECTOR_STYLES.LINE_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: '#FFFFFF'
      }
    },
    [_constants.VECTOR_STYLES.LINE_WIDTH]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: 2
      }
    },
    [_constants.VECTOR_STYLES.SYMBOLIZE_AS]: {
      options: {
        value: _constants.SYMBOLIZE_AS_TYPES.ICON
      }
    },
    [_constants.VECTOR_STYLES.ICON]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        value: 'home'
      }
    },
    [_constants.VECTOR_STYLES.ICON_SIZE]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: 8
      }
    }
  };
  return _vector_layer.GeoJsonVectorLayer.createDescriptor({
    label: _i18n.i18n.translate('xpack.maps.sescurity.sourceLayerLabel', {
      defaultMessage: '{indexPatternTitle} | Source Point',
      values: {
        indexPatternTitle
      }
    }),
    parent: parentId,
    sourceDescriptor,
    style: _vector_style.VectorStyle.createDescriptor(styleProperties)
  });
}
function createDestinationLayerDescriptor(indexPatternId, indexPatternTitle, parentId) {
  const sourceDescriptor = _es_search_source.ESSearchSource.createDescriptor({
    indexPatternId,
    geoField: getDestinationField(indexPatternId),
    scalingType: _constants.SCALING_TYPES.TOP_HITS,
    topHitsSplitField: (0, _apmDataView.isAPMDataView)(indexPatternId) ? 'server.ip' : 'destination.ip',
    tooltipProperties: (0, _apmDataView.isAPMDataView)(indexPatternId) ? ['host.name', 'server.ip', 'server.domain', 'server.geo.country_iso_code', 'server.as.organization.name'] : ['host.name', 'destination.ip', 'destination.domain', 'destination.geo.country_iso_code', 'destination.as.organization.name']
  });
  const styleProperties = {
    [_constants.VECTOR_STYLES.FILL_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: euiVisColorPalette[2]
      }
    },
    [_constants.VECTOR_STYLES.LINE_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: '#FFFFFF'
      }
    },
    [_constants.VECTOR_STYLES.LINE_WIDTH]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: 2
      }
    },
    [_constants.VECTOR_STYLES.SYMBOLIZE_AS]: {
      options: {
        value: _constants.SYMBOLIZE_AS_TYPES.ICON
      }
    },
    [_constants.VECTOR_STYLES.ICON]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        value: 'marker'
      }
    },
    [_constants.VECTOR_STYLES.ICON_SIZE]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        size: 8
      }
    }
  };
  return _vector_layer.GeoJsonVectorLayer.createDescriptor({
    label: _i18n.i18n.translate('xpack.maps.sescurity.destinationLayerLabel', {
      defaultMessage: '{indexPatternTitle} | Destination point',
      values: {
        indexPatternTitle
      }
    }),
    parent: parentId,
    sourceDescriptor,
    style: _vector_style.VectorStyle.createDescriptor(styleProperties)
  });
}
function createLineLayerDescriptor(indexPatternId, indexPatternTitle, parentId) {
  const sourceDescriptor = _es_pew_pew_source.ESPewPewSource.createDescriptor({
    indexPatternId,
    sourceGeoField: getSourceField(indexPatternId),
    destGeoField: getDestinationField(indexPatternId),
    metrics: [{
      type: _constants.AGG_TYPE.SUM,
      field: (0, _apmDataView.isAPMDataView)(indexPatternId) ? 'client.bytes' : 'source.bytes'
    }, {
      type: _constants.AGG_TYPE.SUM,
      field: (0, _apmDataView.isAPMDataView)(indexPatternId) ? 'server.bytes' : 'destination.bytes'
    }]
  });
  const styleProperties = {
    [_constants.VECTOR_STYLES.LINE_COLOR]: {
      type: _constants.STYLE_TYPE.STATIC,
      options: {
        color: euiVisColorPalette[1]
      }
    },
    [_constants.VECTOR_STYLES.LINE_WIDTH]: {
      type: _constants.STYLE_TYPE.DYNAMIC,
      options: {
        ...defaultDynamicProperties[_constants.VECTOR_STYLES.LINE_WIDTH].options,
        field: {
          name: _constants.COUNT_PROP_NAME,
          origin: _constants.FIELD_ORIGIN.SOURCE
        },
        minSize: 1,
        maxSize: 8
      }
    }
  };
  return _vector_layer.GeoJsonVectorLayer.createDescriptor({
    label: _i18n.i18n.translate('xpack.maps.sescurity.lineLayerLabel', {
      defaultMessage: '{indexPatternTitle} | Line',
      values: {
        indexPatternTitle
      }
    }),
    parent: parentId,
    sourceDescriptor,
    style: _vector_style.VectorStyle.createDescriptor(styleProperties)
  });
}
function createSecurityLayerDescriptors(indexPatternId, indexPatternTitle) {
  const layerGroupDescriptor = _layer_group.LayerGroup.createDescriptor({
    label: indexPatternTitle
  });
  return [createSourceLayerDescriptor(indexPatternId, indexPatternTitle, layerGroupDescriptor.id), createDestinationLayerDescriptor(indexPatternId, indexPatternTitle, layerGroupDescriptor.id), createLineLayerDescriptor(indexPatternId, indexPatternTitle, layerGroupDescriptor.id), layerGroupDescriptor];
}