"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uploadLayerWizardConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _wizard = require("./wizard");
var _kibana_services = require("../../../../kibana_services");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/wizards/file_upload_wizard/config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const uploadLayerWizardConfig = exports.uploadLayerWizardConfig = {
  id: _constants.WIZARD_ID.GEO_FILE,
  order: 10,
  categories: [],
  description: _i18n.i18n.translate('xpack.maps.fileUploadWizard.description', {
    defaultMessage: 'Index GeoJSON and Shapefile data in Elasticsearch'
  }),
  disabledReason: _i18n.i18n.translate('xpack.maps.fileUploadWizard.disabledDesc', {
    defaultMessage: 'Unable to upload files, you are missing the Kibana privilege "Data View Management".'
  }),
  getIsDisabled: async () => {
    const hasImportPermission = await (0, _kibana_services.getFileUpload)().hasImportPermission({
      checkCreateDataView: true,
      checkHasManagePipeline: false
    });
    return !hasImportPermission;
  },
  icon: 'importAction',
  prerequisiteSteps: [{
    id: _wizard.UPLOAD_STEPS.CONFIGURE_UPLOAD,
    label: _i18n.i18n.translate('xpack.maps.fileUploadWizard.configureUploadLabel', {
      defaultMessage: 'Import file'
    })
  }, {
    id: _wizard.UPLOAD_STEPS.UPLOAD,
    label: _i18n.i18n.translate('xpack.maps.fileUploadWizard.uploadLabel', {
      defaultMessage: 'Importing file'
    })
  }, {
    id: _wizard.UPLOAD_STEPS.ADD_DOCUMENT_LAYER,
    label: _i18n.i18n.translate('xpack.maps.fileUploadWizard.configureDocumentLayerLabel', {
      defaultMessage: 'Add as document layer'
    })
  }],
  renderWizard: renderWizardArguments => {
    return /*#__PURE__*/_react.default.createElement(_wizard.ClientFileCreateSourceEditor, (0, _extends2.default)({}, renderWizardArguments, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    }));
  },
  title: _i18n.i18n.translate('xpack.maps.fileUploadWizard.title', {
    defaultMessage: 'Upload file'
  })
};