"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadESQLAttributes = loadESQLAttributes;
var _esqlUtils = require("@kbn/esql-utils");
var _visualizationUtils = require("@kbn/visualization-utils");
var _utils = require("./initializers/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function loadESQLAttributes({
  dataViews,
  data,
  visualizationMap,
  datasourceMap,
  uiSettings
}) {
  var _suggestionsApi;
  // Early exit if ESQL is not supported
  if (!(0, _utils.isESQLModeEnabled)({
    uiSettings
  })) {
    return;
  }
  const indexName = await (0, _esqlUtils.getIndexForESQLQuery)({
    dataViews
  });
  // Early exit if there's no data view to use
  if (!indexName) {
    return;
  }

  // From this moment on there are no longer early exists before suggestions
  // so make sure to load async modules while doing other async stuff to save some time
  const [dataView, {
    suggestionsApi
  }] = await Promise.all([(0, _esqlUtils.getESQLAdHocDataview)(`from ${indexName}`, dataViews), Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')))]);
  const esqlQuery = (0, _esqlUtils.getInitialESQLQuery)(dataView);
  const defaultEsqlQuery = {
    esql: esqlQuery
  };

  // For the suggestions api we need only the columns
  // so we are requesting them with limit 0
  // this is much more performant than requesting
  // all the table
  const abortController = new AbortController();
  const columns = await (0, _esqlUtils.getESQLQueryColumns)({
    esqlQuery,
    search: data.search.search,
    signal: abortController.signal,
    timeRange: data.query.timefilter.timefilter.getAbsoluteTime()
  });
  const context = {
    dataViewSpec: dataView.toSpec(false),
    fieldName: '',
    textBasedColumns: columns,
    query: defaultEsqlQuery
  };

  // get the initial attributes from the suggestions api
  const allSuggestions = (_suggestionsApi = suggestionsApi({
    context,
    dataView,
    datasourceMap,
    visualizationMap
  })) !== null && _suggestionsApi !== void 0 ? _suggestionsApi : [];

  // Lens might not return suggestions for some cases, i.e. in case of errors
  if (!allSuggestions.length) {
    return;
  }
  const [firstSuggestion] = allSuggestions;
  return (0, _visualizationUtils.getLensAttributesFromSuggestion)({
    filters: [],
    query: defaultEsqlQuery,
    suggestion: {
      ...firstSuggestion,
      title: '' // when creating a new panel, we don't want to use the title from the suggestion
    },
    dataView
  });
}