"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeColumn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeColumn = ({
  prevState,
  layerId,
  columnId
}) => {
  return {
    ...prevState,
    layers: {
      ...prevState.layers,
      [layerId]: {
        ...prevState.layers[layerId],
        columns: prevState.layers[layerId].columns.filter(col => col.columnId !== columnId)
      }
    }
  };
};
exports.removeColumn = removeColumn;