"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsContentPage = exports.LogEntryCategoriesResultsContent = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ml-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _public4 = require("@kbn/logs-shared-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
var _log_analysis_job_status = require("../../../components/logging/log_analysis_job_status");
var _log_analysis_results = require("../../../components/logging/log_analysis_results");
var _datasets_selector = require("../../../components/logging/log_analysis_results/datasets_selector");
var _create_job_button = require("../../../components/logging/log_analysis_setup/create_job_button");
var _log_analysis_capabilities = require("../../../containers/logs/log_analysis/log_analysis_capabilities");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _page_template = require("../shared/page_template");
var _page_view_log_in_context = require("../stream/page_view_log_in_context");
var _top_categories = require("./sections/top_categories");
var _use_log_entry_categories_results = require("./use_log_entry_categories_results");
var _use_log_entry_categories_results_url_state = require("./use_log_entry_categories_results_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/page_results_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JOB_STATUS_POLLING_INTERVAL = 30000;
const LogEntryCategoriesResultsContent = ({
  onOpenSetup,
  pageTitle,
  idFormat
}) => {
  (0, _public3.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_entry_categories_results'
  });
  (0, _public3.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_entry_categories_results',
    delay: 15000
  });
  const {
    services: {
      ml,
      http
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    logViewStatus
  } = (0, _public4.useLogViewContext)();
  const {
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis_capabilities.useLogAnalysisCapabilitiesContext)();
  const {
    fetchJobStatus,
    fetchModuleDefinition,
    moduleDescriptor,
    setupStatus,
    hasOutdatedJobConfigurations,
    hasOutdatedJobDefinitions,
    hasStoppedJobs,
    jobIds,
    categoryQualityWarnings,
    sourceConfiguration: {
      sourceId: logViewId
    }
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const {
    timeRange: selectedTimeRange,
    setTimeRange: setSelectedTimeRange,
    autoRefresh,
    setAutoRefresh
  } = (0, _use_log_entry_categories_results_url_state.useLogEntryCategoriesResultsUrlState)();
  const [categoryQueryTimeRange, setCategoryQueryTimeRange] = (0, _react.useState)(() => ({
    lastChangedTime: Date.now(),
    timeRange: stringToNumericTimeRange(selectedTimeRange)
  }));
  const [categoryQueryDatasets, setCategoryQueryDatasets] = (0, _react.useState)([]);
  const {
    services
  } = (0, _public.useKibana)();
  const showLoadDataErrorNotification = (0, _react.useCallback)(error => {
    var _services$notificatio;
    (_services$notificatio = services.notifications) === null || _services$notificatio === void 0 ? void 0 : _services$notificatio.toasts.addError(error, {
      title: loadDataErrorTitle
    });
  }, [services.notifications]);
  const {
    getLogEntryCategoryDatasets,
    getTopLogEntryCategories,
    isLoadingLogEntryCategoryDatasets,
    isLoadingTopLogEntryCategories,
    logEntryCategoryDatasets,
    topLogEntryCategories,
    sortOptions,
    changeSortOptions
  } = (0, _use_log_entry_categories_results.useLogEntryCategoriesResults)({
    categoriesCount: 25,
    endTime: categoryQueryTimeRange.timeRange.endTime,
    filteredDatasets: categoryQueryDatasets,
    onGetTopLogEntryCategoriesError: showLoadDataErrorNotification,
    logViewReference: {
      type: 'log-view-reference',
      logViewId
    },
    idFormat,
    startTime: categoryQueryTimeRange.timeRange.startTime
  });
  const handleQueryTimeRangeChange = (0, _react.useCallback)(({
    start: startTime,
    end: endTime
  }) => {
    setCategoryQueryTimeRange(previousQueryParameters => ({
      ...previousQueryParameters,
      timeRange: stringToNumericTimeRange({
        startTime,
        endTime
      }),
      lastChangedTime: Date.now()
    }));
  }, [setCategoryQueryTimeRange]);
  const handleSelectedTimeRangeChange = (0, _react.useCallback)(selectedTime => {
    if (selectedTime.isInvalid) {
      return;
    }
    setSelectedTimeRange({
      startTime: selectedTime.start,
      endTime: selectedTime.end
    });
    handleQueryTimeRangeChange(selectedTime);
  }, [setSelectedTimeRange, handleQueryTimeRangeChange]);
  const handleAutoRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval: interval
  }) => {
    setAutoRefresh({
      isPaused,
      interval
    });
  }, [setAutoRefresh]);
  const hasResults = (0, _react.useMemo)(() => topLogEntryCategories.length > 0, [topLogEntryCategories.length]);
  const isFirstUse = (0, _react.useMemo)(() => (setupStatus.type === 'skipped' && !!setupStatus.newlyCreated || setupStatus.type === 'succeeded') && !hasResults, [hasResults, setupStatus]);
  (0, _react.useEffect)(() => {
    getTopLogEntryCategories();
  }, [getTopLogEntryCategories, categoryQueryDatasets, categoryQueryTimeRange.lastChangedTime, sortOptions]);
  (0, _react.useEffect)(() => {
    getLogEntryCategoryDatasets();
  }, [getLogEntryCategoryDatasets, categoryQueryTimeRange.lastChangedTime]);
  (0, _react.useEffect)(() => {
    fetchModuleDefinition();
  }, [fetchModuleDefinition]);
  (0, _useInterval.default)(() => {
    fetchJobStatus();
  }, JOB_STATUS_POLLING_INTERVAL);
  (0, _useInterval.default)(() => {
    handleQueryTimeRangeChange({
      start: selectedTimeRange.startTime,
      end: selectedTimeRange.endTime
    });
  }, autoRefresh.isPaused ? null : autoRefresh.interval);
  const analyzeInMlLink = (0, _public2.useMlHref)(ml, http.basePath.get(), {
    page: _public2.ML_PAGES.ANOMALY_EXPLORER,
    pageState: {
      jobIds: [jobIds[_log_analysis.logEntryCategoriesJobType]],
      timeRange: {
        from: (0, _moment.default)(categoryQueryTimeRange.timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        to: (0, _moment.default)(categoryQueryTimeRange.timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
        mode: 'absolute'
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_view_log_in_context.ViewLogInContextProvider, {
    logViewReference: {
      type: 'log-view-reference',
      logViewId
    },
    startTimestamp: categoryQueryTimeRange.timeRange.startTime,
    endTimestamp: categoryQueryTimeRange.timeRange.endTime,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, {
    hasData: (logViewStatus === null || logViewStatus === void 0 ? void 0 : logViewStatus.index) !== 'missing',
    pageHeader: {
      pageTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_create_job_button.RecreateJobButton, {
        hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
        onClick: onOpenSetup,
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_log_analysis_results.AnalyzeInMlButton, {
        href: analyzeInMlLink,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 13
        }
      })]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_datasets_selector.DatasetsSelector, {
    availableDatasets: logEntryCategoryDatasets,
    isLoading: isLoadingLogEntryCategoryDatasets,
    onChangeDatasetSelection: setCategoryQueryDatasets,
    selectedDatasets: categoryQueryDatasets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: selectedTimeRange.startTime,
    end: selectedTimeRange.endTime,
    onTimeChange: handleSelectedTimeRangeChange,
    isPaused: autoRefresh.isPaused,
    refreshInterval: autoRefresh.interval,
    onRefreshChange: handleAutoRefreshChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.MLJobsAwaitingNodeWarning, {
    jobIds: Object.values(jobIds),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_log_analysis_job_status.CategoryJobNoticesSection, {
    hasOutdatedJobConfigurations: hasOutdatedJobConfigurations,
    hasOutdatedJobDefinitions: hasOutdatedJobDefinitions,
    hasSetupCapabilities: hasLogAnalysisSetupCapabilities,
    hasStoppedJobs: hasStoppedJobs,
    isFirstUse: isFirstUse,
    moduleName: moduleDescriptor.moduleName,
    onRecreateMlJobForReconfiguration: onOpenSetup,
    onRecreateMlJobForUpdate: onOpenSetup,
    qualityWarnings: categoryQualityWarnings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_top_categories.TopCategoriesSection, {
    isLoadingTopCategories: isLoadingTopLogEntryCategories,
    jobId: jobIds[_log_analysis.logEntryCategoriesJobType],
    logViewReference: {
      type: 'log-view-reference',
      logViewId
    },
    timeRange: categoryQueryTimeRange.timeRange,
    topCategories: topLogEntryCategories,
    sortOptions: sortOptions,
    changeSortOptions: changeSortOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_page_view_log_in_context.PageViewLogInContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 7
    }
  }));
};
exports.LogEntryCategoriesResultsContent = LogEntryCategoriesResultsContent;
const stringToNumericTimeRange = timeRange => ({
  startTime: (0, _moment.default)(_datemath.default.parse(timeRange.startTime, {
    momentInstance: _moment.default
  })).valueOf(),
  endTime: (0, _moment.default)(_datemath.default.parse(timeRange.endTime, {
    momentInstance: _moment.default,
    roundUp: true
  })).valueOf()
});

// This is needed due to the flex-basis: 100% !important; rule that
// kicks in on small screens via media queries breaking when using direction="column"
const ResultsContentPage = exports.ResultsContentPage = (0, _styled.default)(_eui.EuiPage)`
  flex: 1 0 0%;
  flex-direction: column;

  [class*='euiFlexGroup-responsive'] > .euiFlexItem {
    flex-basis: auto !important;
  }
`;
const loadDataErrorTitle = _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.loadDataErrorTitle', {
  defaultMessage: 'Failed to load category data'
});