"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleColor = exports.defaultPalette = exports.createPaletteTransformer = exports.colorTransformer = exports.Color = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Color = exports.Color = /*#__PURE__*/function (Color) {
  Color["color0"] = "color0";
  Color["color1"] = "color1";
  Color["color2"] = "color2";
  Color["color3"] = "color3";
  Color["color4"] = "color4";
  Color["color5"] = "color5";
  Color["color6"] = "color6";
  Color["color7"] = "color7";
  Color["color8"] = "color8";
  Color["color9"] = "color9";
  return Color;
}({});
const euiPalette = (0, _eui.euiPaletteColorBlind)();
const defaultPalette = exports.defaultPalette = {
  // TODO: Waiting for the designer input on the colors mapping
  // As a temp solution, in the old palette, colors 0..3 are the dark colors, 4..6 are the light colors and 7..9 dark again
  // I followed the same pattern here for the new palette
  [Color.color0]: euiPalette[0],
  [Color.color1]: euiPalette[2],
  [Color.color2]: euiPalette[4],
  [Color.color3]: euiPalette[6],
  [Color.color4]: euiPalette[1],
  [Color.color5]: euiPalette[3],
  [Color.color6]: euiPalette[5],
  [Color.color7]: euiPalette[8],
  [Color.color8]: euiPalette[9],
  [Color.color9]: euiPalette[7]
};
const createPaletteTransformer = palette => color => palette[color];
exports.createPaletteTransformer = createPaletteTransformer;
const colorTransformer = exports.colorTransformer = createPaletteTransformer(defaultPalette);
const sampleColor = (usedColors = []) => {
  const available = (0, _lodash.difference)((0, _lodash.values)(Color), usedColors);
  return (0, _lodash.first)(available) || Color.color0;
};
exports.sampleColor = sampleColor;