"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateClone = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _components = require("../../components");
var _breadcrumbs = require("../../services/breadcrumbs");
var _routing = require("../../services/routing");
var _api = require("../../services/api");
var _index_templates = require("../../lib/index_templates");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/template_clone/template_clone.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplateClone = ({
  match: {
    params: {
      name
    }
  },
  location,
  history
}) => {
  const decodedTemplateName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    config: {
      enableLegacyTemplates
    }
  } = (0, _app_context.useAppContext)();
  // We don't expect the `legacy` query to be used when legacy templates are disabled, however, we add the `enableLegacyTemplates` check as a safeguard
  const isLegacy = enableLegacyTemplates && (0, _index_templates.getIsLegacyFromQueryParams)(location);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    error: templateToCloneError,
    data: templateToClone,
    isLoading
  } = (0, _api.useLoadIndexTemplate)(decodedTemplateName, isLegacy);
  const onSave = async template => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _api.saveTemplate)(template, true);
    const {
      name: newTemplateName
    } = template;
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }
    history.push((0, _routing.getTemplateDetailsLink)(newTemplateName, template._kbnMeta.isLegacy));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.templateClone);
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateCreate.loadingTemplateToCloneDescription",
      defaultMessage: "Loading template to clone\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }));
  } else if (templateToCloneError) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateCreate.loadingTemplateToCloneErrorMessage",
        defaultMessage: "Error loading template to clone",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }),
      error: templateToCloneError,
      "data-test-subj": "sectionError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    });
  }
  const templateData = {
    ...templateToClone,
    name: `${decodedTemplateName}-copy`
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_components.TemplateForm, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createTemplate.cloneTemplatePageTitle",
      defaultMessage: "Clone template ''{name}''",
      values: {
        name: decodedTemplateName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }),
    defaultValue: templateData,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isLegacy: isLegacy,
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }));
};
exports.TemplateClone = TemplateClone;