"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApplicationResultProvider = void 0;
var _rxjs = require("rxjs");
var _get_app_results = require("./get_app_results");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const applicationType = 'application';
const createApplicationResultProvider = applicationPromise => {
  const searchableApps$ = (0, _rxjs.from)(applicationPromise).pipe((0, _rxjs.mergeMap)(application => application.applications$), (0, _rxjs.map)(apps => [...apps.values()].filter(
  // only include non-chromeless enabled apps
  app => app.status === 0 && app.chromeless !== true)), (0, _rxjs.shareReplay)(1));
  return {
    id: 'application',
    find: ({
      term,
      types,
      tags
    }, {
      aborted$,
      maxResults
    }) => {
      if (tags || types && !types.includes(applicationType)) {
        return (0, _rxjs.of)([]);
      }
      return searchableApps$.pipe((0, _rxjs.takeUntil)(aborted$), (0, _rxjs.take)(1), (0, _rxjs.map)(apps => {
        const results = (0, _get_app_results.getAppResults)(term !== null && term !== void 0 ? term : '', [...apps.values()]);
        return results.sort((a, b) => b.score - a.score).slice(0, maxResults);
      }));
    },
    getSearchableTypes: () => [applicationType]
  };
};
exports.createApplicationResultProvider = createApplicationResultProvider;