"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrentNamespace = getCurrentNamespace;
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * soClient.getCurrentNamespace() returns undefined in the default space.
 * This helper returns the name of the current space and 'default' in the default space.
 * Note: this refers to the current Kibana space, not to be confused with datastream namespaces.
 */
function getCurrentNamespace(soClient) {
  var _soClient$getCurrentN;
  return (_soClient$getCurrentN = soClient.getCurrentNamespace()) !== null && _soClient$getCurrentN !== void 0 ? _soClient$getCurrentN : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
}