"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.backfillOutputPolicyToV7 = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const backfillOutputPolicyToV7 = outputDoc => {
  if (outputDoc.attributes.type === 'kafka' && outputDoc.attributes.topics) {
    if (!outputDoc.attributes.topic) {
      var _outputDoc$attributes, _outputDoc$attributes2, _outputDoc$attributes3;
      outputDoc.attributes.topic = (_outputDoc$attributes = outputDoc.attributes.topics) === null || _outputDoc$attributes === void 0 ? void 0 : (_outputDoc$attributes2 = _outputDoc$attributes.filter(t => !t.when)) === null || _outputDoc$attributes2 === void 0 ? void 0 : (_outputDoc$attributes3 = _outputDoc$attributes2[0]) === null || _outputDoc$attributes3 === void 0 ? void 0 : _outputDoc$attributes3.topic;
    }
    delete outputDoc.attributes.topics;
  }
  return outputDoc;
};
exports.backfillOutputPolicyToV7 = backfillOutputPolicyToV7;