"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _api_privileges = require("../../constants/api_privileges");
var _errors = require("../schema/errors");
var _synced_integrations = require("../../types/models/synced_integrations");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, isServerless) => {
  if (isServerless) {
    return;
  }
  router.versioned.get({
    path: _constants.REMOTE_SYNCED_INTEGRATIONS_API_ROUTES.STATUS_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.READ, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.READ]
      }
    },
    summary: `Get remote synced integrations status`,
    options: {
      tags: ['oas-tag:Fleet remote synced integrations'],
      availability: {
        since: '9.1.0',
        stability: 'stable'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {},
      response: {
        200: {
          body: () => _synced_integrations.GetRemoteSyncedIntegrationsStatusResponseSchema
        },
        400: {
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.getRemoteSyncedIntegrationsStatusHandler);
  router.versioned.get({
    path: _constants.REMOTE_SYNCED_INTEGRATIONS_API_ROUTES.INFO_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [_api_privileges.FLEET_API_PRIVILEGES.SETTINGS.READ, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.READ]
      }
    },
    summary: `Get remote synced integrations status by outputId`,
    options: {
      tags: ['oas-tag:Fleet remote synced integrations'],
      availability: {
        since: '9.1.0',
        stability: 'stable'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetRemoteSyncedIntegrationsInfoRequestSchema,
      response: {
        200: {
          body: () => _synced_integrations.GetRemoteSyncedIntegrationsStatusResponseSchema
        },
        400: {
          body: _errors.genericErrorResponse
        }
      }
    }
  }, _handler.getRemoteSyncedIntegrationsInfoHandler);
};
exports.registerRoutes = registerRoutes;