"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateCloudShellUrl = void 0;
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateCloudShellUrl = ({
  enrollmentAPIKey,
  packagePolicy
}) => {
  var _data$items, _data$items$find, _data$items$find$host;
  const {
    data,
    isLoading
  } = (0, _hooks.useGetFleetServerHosts)();
  let isError = false;
  let error;

  // Default fleet server host
  const fleetServerHost = data === null || data === void 0 ? void 0 : (_data$items = data.items) === null || _data$items === void 0 ? void 0 : (_data$items$find = _data$items.find(item => item.is_default)) === null || _data$items$find === void 0 ? void 0 : (_data$items$find$host = _data$items$find.host_urls) === null || _data$items$find$host === void 0 ? void 0 : _data$items$find$host[0];
  if (!fleetServerHost && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudShell.noFleetServerHost', {
      defaultMessage: 'No Fleet Server host found'
    });
  }
  if (!enrollmentAPIKey && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudShell.noApiKey', {
      defaultMessage: 'No enrollment token found'
    });
  }
  const cloudShellUrl = (0, _services.getCloudShellUrlFromPackagePolicy)(packagePolicy) || '';
  return {
    isLoading,
    cloudShellUrl,
    isError,
    error
  };
};
exports.useCreateCloudShellUrl = useCreateCloudShellUrl;