"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudFormationInstructions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("./hooks");
var _cloud_formation_guide = require("./cloud_formation_guide");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/cloud_security_posture/cloud_formation_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CloudFormationInstructions = ({
  enrollmentAPIKey,
  cloudSecurityIntegration,
  fleetServerHost
}) => {
  var _cloudSecurityIntegra;
  const {
    cloudFormationUrl,
    error,
    isError
  } = (0, _hooks.useCreateCloudFormationUrl)({
    enrollmentAPIKey,
    cloudFormationProps: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.cloudFormationProps,
    fleetServerHost
  });
  if (error && isError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: error,
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "m",
    isLoading: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : cloudSecurityIntegration.isLoading,
    contentAriaLabel: _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.loadingAriaLabel', {
      defaultMessage: 'Loading CloudFormation instructions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_cloud_formation_guide.CloudFormationGuide, {
    awsAccountType: cloudSecurityIntegration === null || cloudSecurityIntegration === void 0 ? void 0 : (_cloudSecurityIntegra = cloudSecurityIntegration.cloudFormationProps) === null || _cloudSecurityIntegra === void 0 ? void 0 : _cloudSecurityIntegra.awsAccountType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "launchCloudFormationButtonAgentFlyoutTestId",
    color: "primary",
    fill: true,
    target: "_blank",
    iconSide: "left",
    iconType: "launch",
    fullWidth: true,
    href: cloudFormationUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.cloudFormation.launchButton",
    defaultMessage: "Launch CloudFormation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })));
};
exports.CloudFormationInstructions = CloudFormationInstructions;