"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepSelectHosts = exports.SelectedPolicyTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _services = require("../../../../../services");
var _components = require("../../../components");
var _step_select_agent_policy = require("./step_select_agent_policy");
var _use_policies = require("./components/use_policies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/step_select_hosts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let SelectedPolicyTab = exports.SelectedPolicyTab = /*#__PURE__*/function (SelectedPolicyTab) {
  SelectedPolicyTab["NEW"] = "new";
  SelectedPolicyTab["EXISTING"] = "existing";
  return SelectedPolicyTab;
}({});
const StyledEuiTabbedContent = (0, _styledComponents.default)(_eui.EuiTabbedContent)`
  [role='tabpanel'] {
    padding-top: ${props => props.theme.eui.euiSizeM};
  }
`;
const StepSelectHosts = ({
  agentPolicies,
  updateAgentPolicies,
  newAgentPolicy,
  updateNewAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation,
  packageInfo,
  setHasAgentPolicyError,
  updateSelectedTab,
  selectedAgentPolicyIds,
  initialSelectedTabIndex
}) => {
  const existingAgentPolicies = (0, _use_policies.useAllNonManagedAgentPolicies)();
  (0, _react.useEffect)(() => {
    if (existingAgentPolicies.length > 0) {
      updateNewAgentPolicy({
        ...newAgentPolicy,
        name: (0, _services.incrementPolicyName)(existingAgentPolicies)
      });
    }
  }, [existingAgentPolicies.length]); // eslint-disable-line react-hooks/exhaustive-deps

  const tabs = [{
    id: SelectedPolicyTab.NEW,
    'data-test-subj': 'newHostsTab',
    name: 'New hosts',
    content: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyIntegrationForm, {
      agentPolicy: newAgentPolicy,
      updateAgentPolicy: updateNewAgentPolicy,
      withSysMonitoring: withSysMonitoring,
      updateSysMonitoring: updateSysMonitoring,
      validation: validation,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    })
  }, {
    id: SelectedPolicyTab.EXISTING,
    'data-test-subj': 'existingHostsTab',
    name: 'Existing hosts',
    content: /*#__PURE__*/_react.default.createElement(_step_select_agent_policy.StepSelectAgentPolicy, {
      packageInfo: packageInfo,
      agentPolicies: agentPolicies,
      updateAgentPolicies: updateAgentPolicies,
      setHasAgentPolicyError: setHasAgentPolicyError,
      initialSelectedAgentPolicyIds: selectedAgentPolicyIds,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    })
  }];
  const handleOnTabClick = tab => updateSelectedTab(tab.id);
  return /*#__PURE__*/_react.default.createElement(StyledEuiTabbedContent, {
    initialSelectedTab: initialSelectedTabIndex ? tabs[initialSelectedTabIndex] : selectedAgentPolicyIds.length > 0 ? tabs[1] : tabs[0],
    tabs: tabs,
    onTabClick: handleOnTabClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  });
};
exports.StepSelectHosts = StepSelectHosts;