"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("./hooks");
var _use_latest_fleet_servers = require("./hooks/use_latest_fleet_servers");
var _steps = require("./steps");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/components/fleet_server_instructions/advanced_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedTab = ({
  selectedPolicyId,
  onClose
}) => {
  const {
    isSelectFleetServerPolicyLoading,
    eligibleFleetServerPolicies,
    refreshEligibleFleetServerPolicies,
    fleetServerPolicyId,
    setFleetServerPolicyId,
    isFleetServerReady,
    serviceToken,
    isLoadingServiceToken,
    generateServiceToken,
    fleetServerHostForm,
    deploymentMode,
    setDeploymentMode
  } = (0, _hooks.useAdvancedForm)();
  const {
    hasRecentlyEnrolledFleetServers
  } = (0, _use_latest_fleet_servers.useLatestFleetServers)();
  const steps = [(0, _steps.getSelectAgentPolicyStep)({
    policyId: fleetServerPolicyId || selectedPolicyId,
    setPolicyId: setFleetServerPolicyId,
    eligibleFleetServerPolicies,
    refreshEligibleFleetServerPolicies
  }), (0, _steps.getSetDeploymentModeStep)({
    deploymentMode,
    setDeploymentMode,
    disabled: !Boolean(fleetServerPolicyId || selectedPolicyId)
  }), (0, _steps.getAddFleetServerHostStep)({
    fleetServerHostForm,
    disabled: !Boolean(fleetServerPolicyId || selectedPolicyId),
    onClose
  }), (0, _steps.getGenerateServiceTokenStep)({
    serviceToken,
    generateServiceToken,
    isLoadingServiceToken,
    disabled: Boolean(!fleetServerHostForm.fleetServerHost) || !Boolean(fleetServerPolicyId || selectedPolicyId)
  }), (0, _steps.getInstallFleetServerStep)({
    isFleetServerReady,
    serviceToken,
    fleetServerHost: fleetServerHostForm.fleetServerHost,
    fleetServerPolicyId: fleetServerPolicyId || selectedPolicyId,
    deploymentMode,
    disabled: !Boolean(serviceToken)
  }), (0, _steps.getConfirmFleetServerConnectionStep)({
    hasRecentlyEnrolledFleetServers,
    disabled: !Boolean(serviceToken)
  })];
  return isSelectFleetServerPolicyLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    className: "eui-textLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  });
};
exports.AdvancedTab = AdvancedTab;