"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.i18nTexts = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const i18nTexts = exports.i18nTexts = {
  tableListTitle: _i18n.i18n.translate('filesManagement.table.title', {
    defaultMessage: 'Files'
  }),
  tableListDescription: _i18n.i18n.translate('filesManagement.table.description', {
    defaultMessage: 'Manage files stored in Kibana.'
  }),
  titleColumnName: _i18n.i18n.translate('filesManagement.table.titleColumnName', {
    defaultMessage: 'Name'
  }),
  entityName: _i18n.i18n.translate('filesManagement.entityName.title', {
    defaultMessage: 'file'
  }),
  retry: _i18n.i18n.translate('filesManagement.button.retry', {
    defaultMessage: 'Retry'
  }),
  entityNamePlural: _i18n.i18n.translate('filesManagement.entityNamePlural.title', {
    defaultMessage: 'files'
  }),
  emptyPromptTitle: _i18n.i18n.translate('filesManagement.emptyPrompt.title', {
    defaultMessage: 'No files found'
  }),
  emptyPromptDescription: _i18n.i18n.translate('filesManagement.emptyPrompt.description', {
    defaultMessage: 'Any files created in Kibana will be listed here.'
  }),
  size: _i18n.i18n.translate('filesManagement.table.sizeColumnName', {
    defaultMessage: 'Size'
  }),
  diagnosticsFlyoutTitle: _i18n.i18n.translate('filesManagement.diagnostics.flyoutTitle', {
    defaultMessage: 'Statistics'
  }),
  diagnosticsFlyoutSummarySectionTitle: _i18n.i18n.translate('filesManagement.diagnostics.summarySectionTitle', {
    defaultMessage: 'Summary'
  }),
  failedToFetchDiagnostics: _i18n.i18n.translate('filesManagement.diagnostics.errorMessage', {
    defaultMessage: 'Could not fetch statistics'
  }),
  diagnosticsSpaceUsed: _i18n.i18n.translate('filesManagement.diagnostics.spaceUsedLabel', {
    defaultMessage: 'Disk space used'
  }),
  diagnosticsTotalCount: _i18n.i18n.translate('filesManagement.diagnostics.totalCountLabel', {
    defaultMessage: 'Number of files'
  }),
  diagnosticsBreakdownsStatus: _i18n.i18n.translate('filesManagement.diagnostics.breakdownStatusTitle', {
    defaultMessage: 'Count by status'
  }),
  diagnosticsBreakdownsExtension: _i18n.i18n.translate('filesManagement.diagnostics.breakdownExtensionTitle', {
    defaultMessage: 'Count by extension'
  }),
  filesFlyoutSize: _i18n.i18n.translate('filesManagement.filesFlyout.sizeLabel', {
    defaultMessage: 'Size'
  }),
  filesFlyoutExtension: _i18n.i18n.translate('filesManagement.filesFlyout.extensionLabel', {
    defaultMessage: 'Extension'
  }),
  filesFlyoutMimeType: _i18n.i18n.translate('filesManagement.filesFlyout.mimeTypeLabel', {
    defaultMessage: 'MIME type'
  }),
  filesFlyoutStatus: _i18n.i18n.translate('filesManagement.filesFlyout.statusLabel', {
    defaultMessage: 'Status'
  }),
  filesFlyoutCreated: _i18n.i18n.translate('filesManagement.filesFlyout.createdLabel', {
    defaultMessage: 'Created'
  }),
  filesFlyoutUpdated: _i18n.i18n.translate('filesManagement.filesFlyout.updatedLabel', {
    defaultMessage: 'Updated'
  }),
  filesFlyoutDownload: _i18n.i18n.translate('filesManagement.filesFlyout.downloadButtonLabel', {
    defaultMessage: 'Download'
  }),
  filesFlyoutPreview: _i18n.i18n.translate('filesManagement.filesFlyout.previewSectionTitle', {
    defaultMessage: 'Preview'
  }),
  filesStatus: {
    AWAITING_UPLOAD: _i18n.i18n.translate('filesManagement.filesFlyout.status.awaitingUpload', {
      defaultMessage: 'Awaiting upload'
    }),
    DELETED: _i18n.i18n.translate('filesManagement.filesFlyout.status.deleted', {
      defaultMessage: 'Deleted'
    }),
    READY: _i18n.i18n.translate('filesManagement.filesFlyout.status.ready', {
      defaultMessage: 'Ready to download'
    }),
    UPLOADING: _i18n.i18n.translate('filesManagement.filesFlyout.status.uploading', {
      defaultMessage: 'Uploading'
    }),
    UPLOAD_ERROR: _i18n.i18n.translate('filesManagement.filesFlyout.status.uploadError', {
      defaultMessage: 'Upload error'
    })
  },
  rowCheckboxDisabled: _i18n.i18n.translate('filesManagement.table.checkBoxDisabledLabel', {
    defaultMessage: 'This file cannot be deleted.'
  })
};