"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKPITrendsLensConfig = getKPITrendsLensConfig;
var _constants = require("../constants");
var _utils = require("../utils");
var _elasticsearch_fieldnames = require("../constants/elasticsearch_fieldnames");
var _labels = require("../constants/labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getKPITrendsLensConfig({
  dataView
}) {
  return {
    defaultSeriesType: 'bar_stacked',
    seriesTypes: [],
    reportType: _constants.ReportTypes.KPI,
    xAxisColumn: {
      sourceField: '@timestamp'
    },
    yAxisColumns: [{
      sourceField: _constants.REPORT_METRIC_FIELD,
      operationType: 'median'
    }],
    hasOperationType: false,
    filterFields: [_elasticsearch_fieldnames.TRANSACTION_URL, _elasticsearch_fieldnames.USER_AGENT_OS, _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_NAME, _elasticsearch_fieldnames.USER_AGENT_DEVICE, {
      field: _elasticsearch_fieldnames.USER_AGENT_NAME,
      nested: _elasticsearch_fieldnames.USER_AGENT_VERSION
    }, _constants.LABEL_FIELDS_FILTER],
    breakdownFields: [_elasticsearch_fieldnames.USER_AGENT_NAME, _elasticsearch_fieldnames.USER_AGENT_OS, _elasticsearch_fieldnames.CLIENT_GEO_COUNTRY_NAME, _elasticsearch_fieldnames.USER_AGENT_DEVICE, _constants.PERCENTILE, _constants.LABEL_FIELDS_BREAKDOWN],
    baseFilters: [...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.TRANSACTION_TYPE, 'page-load', dataView), ...(0, _utils.buildPhraseFilter)(_elasticsearch_fieldnames.PROCESSOR_EVENT, 'transaction', dataView)],
    labels: {
      ..._constants.FieldLabels,
      [_elasticsearch_fieldnames.SERVICE_NAME]: _labels.WEB_APPLICATION_LABEL
    },
    definitionFields: [_elasticsearch_fieldnames.SERVICE_NAME, _elasticsearch_fieldnames.SERVICE_ENVIRONMENT],
    metricOptions: [{
      field: _constants.RECORDS_FIELD,
      id: _constants.RECORDS_FIELD,
      label: _labels.PAGE_VIEWS_LABEL
    }, {
      label: _labels.PAGE_LOAD_TIME_LABEL,
      field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      id: _elasticsearch_fieldnames.TRANSACTION_DURATION,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.BACKEND_TIME_LABEL,
      field: _elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE,
      id: _elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.FCP_LABEL,
      field: _elasticsearch_fieldnames.FCP_FIELD,
      id: _elasticsearch_fieldnames.FCP_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.TBT_LABEL,
      field: _elasticsearch_fieldnames.TBT_FIELD,
      id: _elasticsearch_fieldnames.TBT_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.LCP_LABEL,
      field: _elasticsearch_fieldnames.LCP_FIELD,
      id: _elasticsearch_fieldnames.LCP_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.FID_LABEL,
      field: _elasticsearch_fieldnames.FID_FIELD,
      id: _elasticsearch_fieldnames.FID_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }, {
      label: _labels.CLS_LABEL,
      field: _elasticsearch_fieldnames.CLS_FIELD,
      id: _elasticsearch_fieldnames.CLS_FIELD,
      columnType: _constants.OPERATION_COLUMN
    }]
  };
}