"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommandContext = void 0;
var _resources_helpers = require("../shared/resources_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getCommandContext = async (commandName, queryString, callbacks) => {
  var _await$callbacks$getI, _callbacks$getInferen, _await$callbacks$getE, _callbacks$getEditorE, _callbacks$getJoinInd, _callbacks$canSuggest, _callbacks$canSuggest2, _await$callbacks$getP, _callbacks$getPrefere, _callbacks$canSuggest3, _callbacks$canSuggest4, _callbacks$getVariabl, _await$callbacks$getP2, _callbacks$getPrefere2, _callbacks$canSuggest5, _callbacks$canSuggest6, _callbacks$getVariabl2, _await$callbacks$getP3, _callbacks$getPrefere3, _await$callbacks$getJ, _callbacks$getJoinInd2, _callbacks$canSuggest7, _callbacks$canSuggest8, _await$callbacks$getI2, _callbacks$getInferen2, _callbacks$getTimeser;
  const getSources = (0, _resources_helpers.getSourcesHelper)(callbacks);
  const helpers = (0, _resources_helpers.getPolicyHelper)(callbacks);
  switch (commandName) {
    case 'completion':
      const inferenceEndpoints = ((_await$callbacks$getI = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getInferen = callbacks.getInferenceEndpoints) === null || _callbacks$getInferen === void 0 ? void 0 : _callbacks$getInferen.call(callbacks, 'completion'))) === null || _await$callbacks$getI === void 0 ? void 0 : _await$callbacks$getI.inferenceEndpoints) || [];
      return {
        inferenceEndpoints
      };
    case 'enrich':
      const policies = await helpers.getPolicies();
      const policiesMap = new Map(policies.map(policy => [policy.name, policy]));
      return {
        policies: policiesMap
      };
    case 'from':
      const editorExtensions = (_await$callbacks$getE = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getEditorE = callbacks.getEditorExtensions) === null || _callbacks$getEditorE === void 0 ? void 0 : _callbacks$getEditorE.call(callbacks, queryString))) !== null && _await$callbacks$getE !== void 0 ? _await$callbacks$getE : {
        recommendedQueries: []
      };
      return {
        sources: await getSources(),
        editorExtensions
      };
    case 'join':
      const joinSources = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getJoinInd = callbacks.getJoinIndices) === null || _callbacks$getJoinInd === void 0 ? void 0 : _callbacks$getJoinInd.call(callbacks));
      return {
        joinSources: (joinSources === null || joinSources === void 0 ? void 0 : joinSources.indices) || [],
        supportsControls: (_callbacks$canSuggest = callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$canSuggest2 = callbacks.canSuggestVariables) === null || _callbacks$canSuggest2 === void 0 ? void 0 : _callbacks$canSuggest2.call(callbacks)) !== null && _callbacks$canSuggest !== void 0 ? _callbacks$canSuggest : false
      };
    case 'stats':
      const histogramBarTarget = ((_await$callbacks$getP = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getPrefere = callbacks.getPreferences) === null || _callbacks$getPrefere === void 0 ? void 0 : _callbacks$getPrefere.call(callbacks))) === null || _await$callbacks$getP === void 0 ? void 0 : _await$callbacks$getP.histogramBarTarget) || 50;
      return {
        histogramBarTarget,
        supportsControls: (_callbacks$canSuggest3 = callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$canSuggest4 = callbacks.canSuggestVariables) === null || _callbacks$canSuggest4 === void 0 ? void 0 : _callbacks$canSuggest4.call(callbacks)) !== null && _callbacks$canSuggest3 !== void 0 ? _callbacks$canSuggest3 : false,
        variables: callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getVariabl = callbacks.getVariables) === null || _callbacks$getVariabl === void 0 ? void 0 : _callbacks$getVariabl.call(callbacks)
      };
    case 'inline stats':
      return {
        histogramBarTarget: ((_await$callbacks$getP2 = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getPrefere2 = callbacks.getPreferences) === null || _callbacks$getPrefere2 === void 0 ? void 0 : _callbacks$getPrefere2.call(callbacks))) === null || _await$callbacks$getP2 === void 0 ? void 0 : _await$callbacks$getP2.histogramBarTarget) || 50,
        supportsControls: (_callbacks$canSuggest5 = callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$canSuggest6 = callbacks.canSuggestVariables) === null || _callbacks$canSuggest6 === void 0 ? void 0 : _callbacks$canSuggest6.call(callbacks)) !== null && _callbacks$canSuggest5 !== void 0 ? _callbacks$canSuggest5 : false,
        variables: callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getVariabl2 = callbacks.getVariables) === null || _callbacks$getVariabl2 === void 0 ? void 0 : _callbacks$getVariabl2.call(callbacks)
      };
    case 'fork':
      const enrichPolicies = await helpers.getPolicies();
      return {
        histogramBarTarget: ((_await$callbacks$getP3 = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getPrefere3 = callbacks.getPreferences) === null || _callbacks$getPrefere3 === void 0 ? void 0 : _callbacks$getPrefere3.call(callbacks))) === null || _await$callbacks$getP3 === void 0 ? void 0 : _await$callbacks$getP3.histogramBarTarget) || 50,
        joinSources: ((_await$callbacks$getJ = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getJoinInd2 = callbacks.getJoinIndices) === null || _callbacks$getJoinInd2 === void 0 ? void 0 : _callbacks$getJoinInd2.call(callbacks))) === null || _await$callbacks$getJ === void 0 ? void 0 : _await$callbacks$getJ.indices) || [],
        supportsControls: (_callbacks$canSuggest7 = callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$canSuggest8 = callbacks.canSuggestVariables) === null || _callbacks$canSuggest8 === void 0 ? void 0 : _callbacks$canSuggest8.call(callbacks)) !== null && _callbacks$canSuggest7 !== void 0 ? _callbacks$canSuggest7 : false,
        policies: new Map(enrichPolicies.map(policy => [policy.name, policy])),
        inferenceEndpoints: ((_await$callbacks$getI2 = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getInferen2 = callbacks.getInferenceEndpoints) === null || _callbacks$getInferen2 === void 0 ? void 0 : _callbacks$getInferen2.call(callbacks, 'completion'))) === null || _await$callbacks$getI2 === void 0 ? void 0 : _await$callbacks$getI2.inferenceEndpoints) || []
      };
    case 'ts':
      const timeseriesSources = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getTimeser = callbacks.getTimeseriesIndices) === null || _callbacks$getTimeser === void 0 ? void 0 : _callbacks$getTimeser.call(callbacks));
      return {
        timeSeriesSources: (timeseriesSources === null || timeseriesSources === void 0 ? void 0 : timeseriesSources.indices) || [],
        sources: await getSources()
      };
    default:
      return {};
  }
};
exports.getCommandContext = getCommandContext;