"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildFunctionDocumentation = exports.buildDocumentation = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const declarationLabel = _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.declarationLabel', {
  defaultMessage: 'Declaration:'
});
const examplesLabel = _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.examplesLabel', {
  defaultMessage: 'Examples:'
});

/** @internal */
const buildFunctionDocumentation = (signatures, examples) => `
---
\
***${declarationLabel}***
${signatures.map(({
  declaration,
  license
}) => `
\
  - \`\`${declaration}\`\`${license || ''}\
\
`).join('\n\n')}
  ${examples !== null && examples !== void 0 && examples.length ? `\
---
***${examplesLabel}***
\
  ${examples.map(i => `
  - \`\`${i}\`\`
`).join('')}

` : ''}`;

/** @internal **/
exports.buildFunctionDocumentation = buildFunctionDocumentation;
const buildDocumentation = (declaration, examples) => `
---
\
***${declarationLabel}***
\
  - \`\`${declaration}\`\`
\
---
${examples ? `\
***${examplesLabel}***
\
${examples.map(i => `
  - \`\`${i}\`\`
`)}` : ''}`;
exports.buildDocumentation = buildDocumentation;