"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whereCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const whereCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate
};
const whereCommand = exports.whereCommand = {
  name: 'where',
  methods: whereCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.whereDoc', {
      defaultMessage: 'Uses "predicate-expressions" to filter search results. A predicate expression, when evaluated, returns TRUE or FALSE. The where command only returns the results that evaluate to TRUE. For example, to filter results for a specific field value'
    }),
    declaration: 'WHERE expression',
    examples: ['… | WHERE status_code == 200']
  }
};