"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Basic = Basic;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _addonActions = require("@storybook/addon-actions");
var _hooks = require("../../hooks");
var _use_multi_fields = require("../use_multi_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/use_multi_field_basic.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fields = {
  min: {
    path: 'minValue',
    defaultValue: 0
  },
  max: {
    path: 'maxValue',
    defaultValue: 100
  }
};
function Basic() {
  const [{
    minValue: _min,
    maxValue: _max
  }] = (0, _hooks.useFormData)();
  (0, _react.useEffect)(() => {
    (0, _addonActions.action)('Min max values')([_min, _max]);
  }, [_min, _max]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, "When you need to declare multiple fields you can use \"UseMultiFields\" to avoid nesting multiple \"UseField\"."))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Range",
    helpText: "The <EuiDualRange /> component sets 2 values in the form.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_multi_fields.UseMultiFields, {
    fields: fields,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, ({
    min,
    max
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
      min: 0,
      max: 100,
      value: [min.value, max.value],
      onChange: ([minValue, maxValue]) => {
        min.setValue(minValue);
        max.setValue(maxValue);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    });
  })));
}
Basic.storyName = 'Basic';
Basic.parameters = {
  docs: {
    source: {
      code: `
const fields = {
  min: {
    path: 'minValue',
    defaultValue: 0,
  },
  max: {
    path: 'maxValue',
    defaultValue: 100,
  },
};

const MyFormComponent = () => {
  const { form } = useForm({ defaultValue });

  const [{ minValue: _min, maxValue: _max }] = useFormData();

  useEffect(() => {
    action('Min max values')([_min, _max]);
  }, [_min, _max]);

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiText>
        <p>
          <EuiTextColor color="subdued">
            When you need to declare multiple fields you can use &quot;UseMultiFields&quot; to avoid
            nesting multiple &quot;UseField&quot;.
          </EuiTextColor>
        </p>
      </EuiText>
      <EuiSpacer />

      <EuiFormRow
        label="Range"
        helpText="The <EuiDualRange /> component sets 2 values in the form."
      >
        <UseMultiFields<{ min: number; max: number }> fields={fields}>
          {({ min, max }) => {
            return (
              <EuiDualRange
                min={0}
                max={100}
                value={[min.value, max.value]}
                onChange={([minValue, maxValue]) => {
                  min.setValue(minValue as number);
                  max.setValue(maxValue as number);
                }}
              />
            );
          }}
        </UseMultiFields>
      </EuiFormRow>
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
};
      `,
      language: 'tsx'
    }
  }
};