"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fetch_sync_jobs_stats_api_logic = require("../../api/stats/fetch_sync_jobs_stats_api_logic");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connectors/connector_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorStats = ({
  isCrawler
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tooltipAncherProps = {
    css: (0, _react2.css)`
      margin: ${euiTheme.size.xs};
    `
  };
  const {
    makeRequest
  } = (0, _kea.useActions)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const {
    data
  } = (0, _kea.useValues)(_fetch_sync_jobs_stats_api_logic.FetchSyncJobsStatsApiLogic);
  const connectorCount = ((data === null || data === void 0 ? void 0 : data.connected) || 0) + ((data === null || data === void 0 ? void 0 : data.incomplete) || 0);
  const hasMultipleConnectors = connectorCount > 1;
  const connectedCount = (data === null || data === void 0 ? void 0 : data.connected) || 0;
  const incompleteCount = (data === null || data === void 0 ? void 0 : data.incomplete) || 0;
  const inProgressCount = (data === null || data === void 0 ? void 0 : data.in_progress) || 0;
  const idleCount = (data === null || data === void 0 ? void 0 : data.idle) || 0;
  const orphanedCount = (data === null || data === void 0 ? void 0 : data.orphaned_jobs) || 0;
  const errorCount = (data === null || data === void 0 ? void 0 : data.errors) || 0;
  (0, _react.useEffect)(() => {
    makeRequest({
      isCrawler
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }, !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.connectorSummaryLabel', {
    defaultMessage: 'Connector summary'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.crawlerSummaryLabel', {
    defaultMessage: 'Web crawler summary'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  }, !isCrawler ? hasMultipleConnectors ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.multipleConnectorsText', {
    defaultMessage: '{count} connectors',
    values: {
      count: connectorCount
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.singleConnectorText', {
    defaultMessage: '{count} connector',
    values: {
      count: connectorCount
    }
  }) : hasMultipleConnectors ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.multipleCrawlersText', {
    defaultMessage: '{count} web crawlers',
    values: {
      count: connectorCount
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.singleCrawlerText', {
    defaultMessage: '{count} web crawler',
    values: {
      count: connectorCount
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getConnectedConnectorsTooltipContent)(connectedCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success",
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getConnectedBadgeAriaLabel)(connectedCount),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, (0, _utils.getConnectedConnectorsBadgeLabel)(connectedCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getIncompleteConnectorsTooltip)(incompleteCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getIncompleteConnectorBadgeAriaLabel)(incompleteCount),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  }, (0, _utils.getIncompleteConnectorsBadgeLabel)(incompleteCount)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorStats.h4.syncsStatusLabel', {
    defaultMessage: 'Syncs status'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }, (0, _utils.getRunningJobsLabel)(inProgressCount, isCrawler))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getRunningJobsTooltip)(inProgressCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getRunningJobsBadgeAriaLabel)(inProgressCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, (0, _utils.getRunningJobsBadgeLabel)(inProgressCount, isCrawler))), !isCrawler && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getIdleJobsTooltip)(idleCount),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getIdleJobsLabel)(idleCount),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, (0, _utils.getIdleJobsLabel)(idleCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getOrphanedJobsTooltip)(orphanedCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getOrphanedJobsLabel)(orphanedCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, (0, _utils.getOrphanedJobsLabel)(orphanedCount, isCrawler))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorProps: tooltipAncherProps,
    content: (0, _utils.getSyncJobErrorsTooltip)(errorCount, isCrawler),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: () => {},
    onClickAriaLabel: (0, _utils.getSyncJobErrorsLabel)(errorCount, isCrawler),
    color: errorCount > 0 ? 'danger' : 'default',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }, (0, _utils.getSyncJobErrorsLabel)(errorCount, isCrawler)))))));
};
exports.ConnectorStats = ConnectorStats;