"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_formula_by_filter = require("../../../utils/get_formula_by_filter");
var _page_template = require("../../layout/page_template");
var _analytics_collection_no_events_callout = require("../analytics_collection_no_events_callout/analytics_collection_no_events_callout");
var _analytics_collection_toolbar = require("../analytics_collection_toolbar/analytics_collection_toolbar");
var _analytics_collection_toolbar_logic = require("../analytics_collection_toolbar/analytics_collection_toolbar_logic");
var _analytics_collection_chart = require("./analytics_collection_chart");
var _analytics_collection_metric = require("./analytics_collection_metric");
var _analytics_collection_overview_table = require("./analytics_collection_overview_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_overview/analytics_collection_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const filters = [{
  id: _get_formula_by_filter.FilterBy.Searches,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.searches', {
    defaultMessage: 'Searches'
  })
}, {
  id: _get_formula_by_filter.FilterBy.NoResults,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.noResults', {
    defaultMessage: 'No results'
  })
}, {
  id: _get_formula_by_filter.FilterBy.Clicks,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.clicks', {
    defaultMessage: 'Click'
  })
}, {
  id: _get_formula_by_filter.FilterBy.Sessions,
  name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.sessions', {
    defaultMessage: 'Sessions'
  })
}];
const AnalyticsCollectionOverview = ({
  analyticsCollection
}) => {
  const {
    setTimeRange
  } = (0, _kea.useActions)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  const {
    timeRange,
    searchSessionId
  } = (0, _kea.useValues)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  const [filterBy, setFilterBy] = (0, _react.useState)(_get_formula_by_filter.FilterBy.Searches);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    restrictWidth: true,
    pageChrome: [analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name],
    analyticsName: analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name,
    pageViewTelemetry: `View Analytics Collection - Overview`,
    pageHeader: {
      bottomBorder: false,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.title', {
        defaultMessage: 'Overview'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.deprecatedBadge', {
        defaultMessage: 'Deprecated'
      })))),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_analytics_collection_toolbar.AnalyticsCollectionToolbar, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 26
        }
      })]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_analytics_collection_no_events_callout.AnalyticsCollectionNoEventsCallout, {
    analyticsCollection: analyticsCollection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, filters.map(({
    name,
    id
  }) => /*#__PURE__*/_react.default.createElement(_analytics_collection_metric.AnalyticsCollectionViewMetricWithLens, {
    key: id,
    id: `analytics-collection-metric-${analyticsCollection.name}-${id}`,
    isSelected: filterBy === id,
    name: name,
    onClick: event => {
      var _event$currentTarget;
      (_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 ? void 0 : _event$currentTarget.blur();
      setFilterBy(id);
    },
    collection: analyticsCollection,
    timeRange: timeRange,
    searchSessionId: searchSessionId,
    getFormula: _get_formula_by_filter.getFormulaByFilter.bind(null, id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_analytics_collection_chart.AnalyticsCollectionChartWithLens, {
    id: 'analytics-collection-chart-' + analyticsCollection.name,
    collection: analyticsCollection,
    timeRange: timeRange,
    setTimeRange: setTimeRange,
    searchSessionId: searchSessionId,
    selectedChart: filterBy,
    setSelectedChart: setFilterBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_analytics_collection_overview_table.AnalyticsCollectionOverviewTable, {
    filterBy: filterBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  })));
};
exports.AnalyticsCollectionOverview = AnalyticsCollectionOverview;