"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.javascriptClientEmbedSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_integrate/analytics_collection_integrate_javascript_client_embed.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const javascriptClientEmbedSteps = analyticsConfig => [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepOne.title', {
    defaultMessage: 'Install client'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepOne.description', {
    defaultMessage: 'Download the behavioral analytics javascript tracker client from NPM.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, 'npm install @elastic/behavioral-analytics-javascript-tracker')))
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepTwo.title', {
    defaultMessage: 'Import the client'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepTwo.description', {
    defaultMessage: 'Import the client in your application.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "bash",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, `import {
  createTracker,
  trackPageView,
  trackSearch,
  trackSearchClick
} from "@elastic/behavioral-analytics-javascript-tracker";`)))
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepThree.title', {
    defaultMessage: 'Initialize the client'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepThree.description', {
    defaultMessage: 'Use createTracker method to initialize the tracker with your Configuration. You will then be able to use the tracker to send events to Behavioral Analytics.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepThree.descriptionTwo', {
    defaultMessage: 'Once you have called createTracker, you can use the tracker methods such as trackPageView to send events to Behavioral Analytics.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, `createTracker({
  endpoint: "${analyticsConfig.endpoint}",
  collectionName: "${analyticsConfig.collectionName}",
  apiKey: "${analyticsConfig.apiKey}"
});`)))
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepFour.title', {
    defaultMessage: 'Dispatch Pageview and search behavior events'
  }),
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepFour.descriptionTwo', {
    defaultMessage: 'Once initialized, you will be able to track page views in your application.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, `import { useEffect } from 'react';

// track a page view in React

const SearchPage = (props) => {
  useEffect(() => {
    trackPageView();
  }, []);

  return (
    <div>
      <h1>Search Page</h1>
    </div>
  );
};`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.integrateTab.javascriptClientEmbed.stepFour.descriptionThree', {
    defaultMessage: 'You can also use trackSearch and trackSearchClick to track what your customers are searching and clicking on in your application.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "javascript",
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, `
import { trackSearch } from '@elastic/behavioral-analytics-javascript-tracker';

const SearchResult = ({ hit }) => {

  const clickHandler = () => {
    trackSearchClick({
      document: { id: hit.id, index: "products" },
      page: {
        url: "http://my-website.com/products/123"
      },
      search: {
        query: "search term",
        filters: {},
        page: { current: 1, size: 10 },
        results: {
          items: [
            {
              document: {
                id: "123",
                index: "products",
              },
              page: {
                url: "http://my-website.com/products/123",
              },
            },
          ],
          total_results: 10
        },
        sort: {
          name: "relevance",
        },
        search_application: "website",
      }
    })
  }

  return (
    <a onClick={clickHandler}>
      <h2>{hit.title}</h2>
    </a>
  )
}`)))
}];
exports.javascriptClientEmbedSteps = javascriptClientEmbedSteps;