"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMBEDDABLE_PACKAGE_STATE_KEY = exports.EMBEDDABLE_EDITOR_STATE_KEY = void 0;
exports.isEmbeddableEditorState = isEmbeddableEditorState;
exports.isEmbeddablePackageState = isEmbeddablePackageState;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EMBEDDABLE_EDITOR_STATE_KEY = exports.EMBEDDABLE_EDITOR_STATE_KEY = 'embeddable_editor_state';

/**
 * A state package that contains information an editor will need to create or edit an embeddable then redirect back.
 * @public
 */

function isEmbeddableEditorState(state) {
  return ensureFieldOfTypeExists('originatingApp', state, 'string');
}
const EMBEDDABLE_PACKAGE_STATE_KEY = exports.EMBEDDABLE_PACKAGE_STATE_KEY = 'embeddable_package_state';

/**
 * A state package that contains all fields necessary to create or update an embeddable by reference or by value in a container.
 * @public
 */

function isEmbeddablePackageState(state) {
  return ensureFieldOfTypeExists('type', state, 'string') && ensureFieldOfTypeExists('serializedState', state, 'object');
}
function ensureFieldOfTypeExists(key, obj, type) {
  return Boolean(obj) && key in obj && (!type || typeof obj[key] === type);
}