"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/presentation-panel-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _phase_tracker = require("./phase_tracker");
var _react_embeddable_registry = require("./react_embeddable_registry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/embeddable/public/react_embeddable_system/react_embeddable_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders a component from the React Embeddable registry into a Presentation Panel.
 */
const EmbeddableRenderer = ({
  type,
  maybeId,
  getParentApi,
  panelProps,
  onApiAvailable,
  hidePanelChrome
}) => {
  const phaseTracker = (0, _react.useRef)(new _phase_tracker.PhaseTracker());
  const componentPromise = (0, _react.useMemo)(() => {
    const uuid = maybeId !== null && maybeId !== void 0 ? maybeId : (0, _uuid.v4)();

    /**
     * Build the embeddable
     */
    return (async () => {
      const parentApi = getParentApi();
      const buildEmbeddable = async () => {
        var _parentApi$getSeriali;
        const factory = await (0, _react_embeddable_registry.getReactEmbeddableFactory)(type);
        const finalizeApi = apiRegistration => {
          const hasLockedHoverActions$ = new _rxjs.BehaviorSubject(false);
          return {
            ...apiRegistration,
            uuid,
            phase$: phaseTracker.current.getPhase$(),
            parentApi,
            hasLockedHoverActions$,
            lockHoverActions: lock => {
              hasLockedHoverActions$.next(lock);
            },
            type: factory.type
          };
        };
        const initialState = (_parentApi$getSeriali = parentApi.getSerializedStateForChild(uuid)) !== null && _parentApi$getSeriali !== void 0 ? _parentApi$getSeriali : {
          rawState: {}
        };
        const {
          api,
          Component
        } = await factory.buildEmbeddable({
          initialState,
          finalizeApi,
          uuid,
          parentApi
        });
        phaseTracker.current.trackPhaseEvents(uuid, api);
        return {
          api,
          Component
        };
      };
      try {
        const {
          api,
          Component
        } = await buildEmbeddable();
        onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(api);
        return /*#__PURE__*/_react.default.forwardRef((_, ref) => {
          // expose the api into the imperative handle
          (0, _react.useImperativeHandle)(ref, () => api, []);
          return /*#__PURE__*/_react.default.createElement(Component, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 108,
              columnNumber: 20
            }
          });
        });
      } catch (e) {
        /**
         * critical error encountered when trying to build the api / embeddable;
         * since no API is available, create a dummy API that allows the panel to be deleted
         * */
        const errorApi = {
          uuid,
          blockingError$: new _rxjs.BehaviorSubject(e)
        };
        if ((0, _presentationContainers.apiIsPresentationContainer)(parentApi)) {
          errorApi.parentApi = parentApi;
        }
        return /*#__PURE__*/_react.default.forwardRef((_, ref) => {
          // expose the dummy error api into the imperative handle
          (0, _react.useImperativeHandle)(ref, () => errorApi, []);
          return null;
        });
      }
    })();
  },
  /**
   * Disabling exhaustive deps because we do not want to re-fetch the component
   * from the embeddable registry unless the type changes.
   */
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [type]);
  return /*#__PURE__*/_react.default.createElement(_public.PresentationPanel, (0, _extends2.default)({
    hidePanelChrome: hidePanelChrome
  }, panelProps, {
    Component: componentPromise,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }));
};
exports.EmbeddableRenderer = EmbeddableRenderer;