"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSearchSource = exports.getTimeRangeFromFetchContext = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getTimeRangeFromFetchContext = fetchContext => {
  const timeRange = fetchContext.timeslice !== undefined ? {
    from: new Date(fetchContext.timeslice[0]).toISOString(),
    to: new Date(fetchContext.timeslice[1]).toISOString(),
    mode: 'absolute'
  } : fetchContext.timeRange;
  if (!timeRange) return undefined;
  return timeRange;
};
exports.getTimeRangeFromFetchContext = getTimeRangeFromFetchContext;
const getTimeRangeFilter = (discoverServices, dataView, fetchContext) => {
  const timeRange = getTimeRangeFromFetchContext(fetchContext);
  if (!dataView || !timeRange) return undefined;
  return discoverServices.timefilter.createFilter(dataView, timeRange);
};
const updateSearchSource = (discoverServices, searchSource, dataView, sort, sampleSize, fetchContext, defaults) => {
  const {
    sortDir
  } = defaults;
  searchSource.setField('size', sampleSize);
  searchSource.setField('highlightAll', true);
  searchSource.setField('sort', (0, _discoverUtils.getSortForSearchSource)({
    sort,
    dataView,
    defaultSortDir: sortDir,
    includeTieBreaker: true
  }));
  searchSource.removeField('fieldsFromSource');
  searchSource.setField('fields', [{
    field: '*',
    include_unmapped: true
  }]);

  // if the search source has a parent, update that too based on fetch context
  const parentSearchSource = searchSource.getParent();
  if (parentSearchSource) {
    var _fetchContext$filters;
    const timeRangeFilter = getTimeRangeFilter(discoverServices, dataView, fetchContext);
    const filters = timeRangeFilter ? [timeRangeFilter, ...((_fetchContext$filters = fetchContext.filters) !== null && _fetchContext$filters !== void 0 ? _fetchContext$filters : [])] : fetchContext.filters;
    parentSearchSource.setField('filter', filters);
    parentSearchSource.setField('query', fetchContext.query);
  }
};
exports.updateSearchSource = updateSearchSource;