"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProfileProviderServices = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Dependencies required by profile provider implementations
 */

/**
 * Services provided to profile provider implementations
 */

/**
 * Creates the profile provider services
 * @param _deps Profile provider dependencies
 * @returns Profile provider services
 */
const createProfileProviderServices = async discoverServices => {
  return {
    ...discoverServices,
    logsContextService: await (0, _discoverUtils.createLogsContextService)({
      logsDataAccess: discoverServices.logsDataAccess
    }),
    tracesContextService: await (0, _discoverUtils.createTracesContextService)({
      apmSourcesAccess: discoverServices.apmSourcesAccess
    }),
    apmErrorsContextService: await (0, _discoverUtils.createApmErrorsContextService)({
      apmSourcesAccess: discoverServices.apmSourcesAccess
    }),
    metricsContextService: await (0, _discoverUtils.createMetricsContextService)({
      metricsExperience: discoverServices.metricsExperience
    })
  };
};
exports.createProfileProviderServices = createProfileProviderServices;