"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsAppMenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _lib = require("@kbn/response-ops-rule-form/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/app_menu_actions/get_alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EsQueryValidConsumer = [_ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.OBSERVABILITY, _ruleDataUtils.STACK_ALERTS_FEATURE_ID];
const RuleFormFlyoutWithType = _flyout.RuleFormFlyout;
const CreateAlertFlyout = ({
  stateContainer,
  discoverParams,
  services,
  onFinishAction
}) => {
  const query = stateContainer.appState.getState().query;
  const {
    dataView,
    isEsqlMode,
    adHocDataViews,
    actions: {
      updateAdHocDataViews
    }
  } = discoverParams;
  const {
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    }
  } = services;
  const timeField = getTimeField(dataView);

  /**
   * Provides the default parameters used to initialize the new rule
   */
  const getParams = (0, _react.useCallback)(() => {
    if (isEsqlMode) {
      return {
        searchType: 'esqlQuery',
        esqlQuery: query,
        timeField
      };
    }
    const savedQueryId = stateContainer.appState.getState().savedQuery;
    return {
      searchType: 'searchSource',
      searchConfiguration: stateContainer.savedSearchState.getState().searchSource.getSerializedFields(),
      savedQueryId
    };
  }, [isEsqlMode, stateContainer.appState, stateContainer.savedSearchState, query, timeField]);
  const discoverMetadata = (0, _react.useMemo)(() => ({
    isManagementPage: false,
    adHocDataViewList: adHocDataViews
  }), [adHocDataViews]);

  // Some of the rule form's required plugins are from x-pack, so make sure they're defined before
  // rendering the flyout. The alerting plugin is also part of x-pack, so this check should probably never
  // return false. This is mostly here because Typescript requires us to mark x-pack plugins as optional.
  if (!(0, _lib.isValidRuleFormPlugins)(services)) return null;
  return /*#__PURE__*/_react.default.createElement(RuleFormFlyoutWithType, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    initialMetadata: discoverMetadata,
    consumer: 'alerts',
    onCancel: onFinishAction,
    onSubmit: onFinishAction,
    onChangeMetaData: metadata => updateAdHocDataViews(metadata.adHocDataViewList),
    ruleTypeId: _ruleDataUtils.ES_QUERY_ID,
    initialValues: {
      params: getParams()
    },
    validConsumers: EsQueryValidConsumer,
    shouldUseRuleProducer: true
    // Default to the Logs consumer if it's available. This should fall back to Stack Alerts if it's not.
    ,
    multiConsumerSelection: _ruleDataUtils.AlertConsumers.LOGS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  });
};
const getAlertsAppMenuItem = ({
  discoverParams,
  services,
  stateContainer
}) => {
  var _services$capabilitie, _services$capabilitie2;
  const {
    dataView,
    isEsqlMode
  } = discoverParams;
  const timeField = getTimeField(dataView);
  const hasTimeFieldName = !isEsqlMode ? Boolean(dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) : Boolean(timeField);
  return {
    id: _discoverUtils.AppMenuActionId.alerts,
    type: _discoverUtils.AppMenuActionType.secondary,
    label: _i18n.i18n.translate('discover.localMenu.localMenu.alertsTitle', {
      defaultMessage: 'Alerts'
    }),
    description: _i18n.i18n.translate('discover.localMenu.alertsDescription', {
      defaultMessage: 'Alerts'
    }),
    testId: 'discoverAlertsButton',
    actions: (_services$capabilitie = services.capabilities.management) !== null && _services$capabilitie !== void 0 && (_services$capabilitie2 = _services$capabilitie.insightsAndAlerting) !== null && _services$capabilitie2 !== void 0 && _services$capabilitie2.triggersActions ? [...(discoverParams.authorizedRuleTypeIds.includes(_ruleDataUtils.ES_QUERY_ID) ? [{
      id: _discoverUtils.AppMenuActionId.createRule,
      type: _discoverUtils.AppMenuActionType.secondary,
      controlProps: {
        label: _i18n.i18n.translate('discover.alerts.createSearchThreshold', {
          defaultMessage: 'Create search threshold rule'
        }),
        iconType: 'bell',
        testId: 'discoverCreateAlertButton',
        disableButton: !hasTimeFieldName,
        tooltip: hasTimeFieldName ? undefined : _i18n.i18n.translate('discover.alerts.missedTimeFieldToolTip', {
          defaultMessage: 'Data view does not have a time field.'
        }),
        onClick: async params => {
          return /*#__PURE__*/_react.default.createElement(CreateAlertFlyout, (0, _extends2.default)({}, params, {
            discoverParams: discoverParams,
            services: services,
            stateContainer: stateContainer,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 162,
              columnNumber: 25
            }
          }));
        }
      }
    }] : []), {
      id: 'alertsDivider',
      type: _discoverUtils.AppMenuActionType.submenuHorizontalRule,
      order: 109
    }, {
      id: _discoverUtils.AppMenuActionId.manageRulesAndConnectors,
      type: _discoverUtils.AppMenuActionType.secondary,
      order: 110,
      controlProps: {
        label: _i18n.i18n.translate('discover.alerts.manageRulesAndConnectors', {
          defaultMessage: 'Manage rules and connectors'
        }),
        iconType: 'tableOfContents',
        testId: 'discoverManageAlertsButton',
        href: services.application.getUrlForApp('management/insightsAndAlerting/triggersActions/rules'),
        onClick: undefined
      }
    }] : []
  };
};
exports.getAlertsAppMenuItem = getAlertsAppMenuItem;
function getTimeField(dataView) {
  var _dateFields$;
  const dateFields = dataView === null || dataView === void 0 ? void 0 : dataView.fields.getByType('date');
  return (dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) || (dateFields === null || dateFields === void 0 ? void 0 : (_dateFields$ = dateFields[0]) === null || _dateFields$ === void 0 ? void 0 : _dateFields$.name);
}