"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnifiedHistogramCommon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _redux = require("../../state_management/redux");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useUnifiedHistogramCommon = ({
  currentTabId,
  layoutProps,
  stateContainer,
  panelsToggle,
  localStorageKeyPrefix
}) => {
  (0, _react.useEffect)(() => {
    if (!layoutProps) {
      return;
    }
    const histogramConfig$ = (0, _redux.selectTabRuntimeState)(stateContainer.runtimeStateManager, currentTabId).unifiedHistogramConfig$;
    histogramConfig$.next({
      ...histogramConfig$.getValue(),
      layoutPropsMap: {
        ...histogramConfig$.getValue().layoutPropsMap,
        [localStorageKeyPrefix !== null && localStorageKeyPrefix !== void 0 ? localStorageKeyPrefix : _redux.DEFAULT_HISTOGRAM_KEY_PREFIX]: layoutProps
      }
    });
  }, [currentTabId, layoutProps, localStorageKeyPrefix, stateContainer.runtimeStateManager]);
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const renderCustomChartToggleActions = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
    renderedFor: 'histogram'
  }) : panelsToggle, [panelsToggle]);
  return {
    isEsqlMode,
    renderCustomChartToggleActions
  };
};
exports.useUnifiedHistogramCommon = useUnifiedHistogramCommon;