"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CurrentQualityIssuesToggle = CurrentQualityIssuesToggle;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_quality_issues_filters = require("../../../../../hooks/use_quality_issues_filters");
var _translations = require("../../../../../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/quality_issues/filters/current_quality_issues_toggle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CurrentQualityIssuesToggle() {
  const toggleTextSwitchId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'toggleTextSwitch'
  });
  const {
    toggleCurrentQualityIssues,
    showCurrentQualityIssues
  } = (0, _use_quality_issues_filters.useQualityIssuesFilters)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    hasActiveFilters: showCurrentQualityIssues,
    isSelected: showCurrentQualityIssues,
    onClick: toggleCurrentQualityIssues,
    "aria-describedby": toggleTextSwitchId,
    "data-test-subj": "datasetQualityDetailsOverviewDegradedFieldToggleSwitch",
    isToggle: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }, _translations.currentIssuesToggleSwitch, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _translations.currentIssuesToggleSwitchTooltip,
    position: "top",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  })));
}