"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _json_editor = require("./json_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/mappings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Mappings = ({
  mappings,
  setMappings,
  showTitle,
  showBorder = false,
  readonly = false,
  fileCount = 1
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [localMappings, setLocalMappings] = (0, _react.useState)(JSON.stringify(mappings, null, 2));
  (0, _react.useEffect)(() => {
    setLocalMappings(JSON.stringify(mappings, null, 2));
  }, [mappings]);
  (0, _useDebounce.default)(() => {
    if (setMappings) {
      const mOriginal = JSON.stringify(mappings);
      const mLocal = JSON.stringify(JSON.parse(localMappings));
      if (mOriginal !== mLocal) {
        setMappings(localMappings);
      }
    }
  }, 500, [localMappings]);
  const css = (0, _react.useMemo)(() => readonly ? {} : {
    backgroundColor: euiTheme.colors.backgroundBaseSubdued
  }, [euiTheme, readonly]);
  const editor = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: showBorder,
    paddingSize: "none",
    "data-test-subj": "dvMappingsEditor",
    css: css,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: _json_editor.EDITOR_MODE.JSON,
    readOnly: readonly,
    value: localMappings,
    onChange: value => {
      setLocalMappings(value);
    },
    transparentBackground: readonly === false,
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
  const title = fileCount > 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.advancedImportSettings.mappingsLabel",
    defaultMessage: "Combined mappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.advancedImportSettings.singleFileMappingLabel",
    defaultMessage: "Mappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, readonly ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "primary",
    iconType: "readOnly",
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.mappingsReadonlyWarning', {
      defaultMessage: 'Mappings for individual files are not editable.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.advancedImportSettings.mappingsWarning",
    defaultMessage: "You can only edit combined mappings under advanced options.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })) : null, showTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: title,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, editor) : editor);
};
exports.Mappings = Mappings;