"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SerializableType = void 0;
exports.deserializeField = deserializeField;
exports.serializeField = serializeField;
var _search = require("./search");
var _serializable_field = require("./serializable_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * All available serialized forms of complex/instance fields. Excludes non-complex/primitive fields.
 *
 * Use `SerializedValue` for all generalize serial values which includes non-complex/primitive fields.
 *
 * Currently includes:
 * - `RangeKey`
 * - `MultiFieldKey`
 */

/**
 * Alias for unknown serialized value. This value is what we store in the SO and app state
 * to persist the color assignment based on the raw row value.
 *
 * In most cases this is a `string` or `number` or plain `object`, in other cases this is an
 * object serialized from an instance of a given field (i.e. `RangeKey` or `MultiFieldKey`).
 */

const SerializableType = exports.SerializableType = {
  MultiFieldKey: 'multiFieldKey',
  RangeKey: 'rangeKey'
};
function deserializeField(field) {
  const type = field != null && (field === null || field === void 0 ? void 0 : field.type);
  switch (type) {
    case SerializableType.MultiFieldKey:
      return _search.MultiFieldKey.deserialize(field);
    case SerializableType.RangeKey:
      return _search.RangeKey.deserialize(field);
    default:
      return field;
  }
}
function serializeField(field) {
  if (field == null || !_serializable_field.SerializableField.isSerializable(field)) return field;
  return field.serialize();
}