"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFormErrors = exports.AutoFollowPatternForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _shared_imports = require("../../shared_imports");
var _routing = require("../services/routing");
var _get_remote_cluster_name = require("../services/get_remote_cluster_name");
var _constants = require("../constants");
var _section_error = require("./section_error");
var _auto_follow_pattern_indices_preview = require("./auto_follow_pattern_indices_preview");
var _remote_clusters_form_field = require("./remote_clusters_form_field");
var _auto_follow_pattern_validators = require("../services/auto_follow_pattern_validators");
var _auto_follow_pattern_request_flyout = require("./auto_follow_pattern_request_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/auto_follow_pattern_form.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const indexPatternIllegalCharacters = _public.indexPatterns.ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const indexNameIllegalCharacters = _shared_imports.indices.INDEX_ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const getEmptyAutoFollowPattern = (remoteClusterName = '') => ({
  name: '',
  remoteCluster: remoteClusterName,
  leaderIndexPatterns: [],
  followIndexPatternPrefix: '',
  followIndexPatternSuffix: ''
});
const updateFormErrors = (errors, existingErrors) => ({
  fieldsErrors: {
    ...existingErrors,
    ...errors
  }
});
exports.updateFormErrors = updateFormErrors;
class AutoFollowPatternForm extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "toggleRequest", () => {
      this.setState(({
        isRequestVisible
      }) => ({
        isRequestVisible: !isRequestVisible
      }));
    });
    (0, _defineProperty2.default)(this, "onFieldsChange", fields => {
      this.setState(({
        autoFollowPattern
      }) => ({
        autoFollowPattern: {
          ...autoFollowPattern,
          ...fields
        }
      }));
      const errors = (0, _auto_follow_pattern_validators.validateAutoFollowPattern)(fields);
      this.onFieldsErrorChange(errors);
    });
    (0, _defineProperty2.default)(this, "onFieldsErrorChange", errors => this.setState(({
      fieldsErrors
    }) => updateFormErrors(errors, fieldsErrors)));
    (0, _defineProperty2.default)(this, "onClusterChange", remoteCluster => {
      this.onFieldsChange({
        remoteCluster
      });
    });
    (0, _defineProperty2.default)(this, "onCreateLeaderIndexPattern", indexPattern => {
      const error = (0, _auto_follow_pattern_validators.validateLeaderIndexPattern)(indexPattern);
      if (error) {
        const errors = {
          leaderIndexPatterns: {
            ...error,
            alwaysVisible: true
          }
        };
        this.setState(({
          fieldsErrors
        }) => updateFormErrors(errors, fieldsErrors));

        // Return false to explicitly reject the user's input.
        return false;
      }
      const {
        autoFollowPattern: {
          leaderIndexPatterns
        }
      } = this.state;
      const newLeaderIndexPatterns = [...leaderIndexPatterns, indexPattern];
      this.onFieldsChange({
        leaderIndexPatterns: newLeaderIndexPatterns
      });
    });
    (0, _defineProperty2.default)(this, "onLeaderIndexPatternChange", indexPatterns => {
      this.onFieldsChange({
        leaderIndexPatterns: indexPatterns.map(({
          label
        }) => label)
      });
    });
    (0, _defineProperty2.default)(this, "onLeaderIndexPatternInputChange", leaderIndexPattern => {
      const isEmpty = !leaderIndexPattern || !leaderIndexPattern.trim();
      const {
        autoFollowPattern: {
          leaderIndexPatterns
        }
      } = this.state;
      if (!isEmpty && leaderIndexPatterns.includes(leaderIndexPattern)) {
        const errorMsg = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.leaderIndexPatternError.duplicateMessage', {
          defaultMessage: `Duplicate leader index pattern aren't allowed.`
        });
        const errors = {
          leaderIndexPatterns: {
            message: errorMsg,
            alwaysVisible: true
          }
        };
        this.setState(({
          fieldsErrors
        }) => updateFormErrors(errors, fieldsErrors));
      } else {
        this.setState(({
          fieldsErrors,
          autoFollowPattern: {
            leaderIndexPatterns
          }
        }) => {
          const errors = Boolean(leaderIndexPatterns.length) ?
          // Validate existing patterns, so we can surface an error if this required input is missing.
          (0, _auto_follow_pattern_validators.validateAutoFollowPattern)({
            leaderIndexPatterns
          }) :
          // Validate the input as the user types so they have immediate feedback about errors.
          (0, _auto_follow_pattern_validators.validateAutoFollowPattern)({
            leaderIndexPatterns: [leaderIndexPattern]
          });
          return updateFormErrors(errors, fieldsErrors);
        });
      }
    });
    (0, _defineProperty2.default)(this, "getFields", () => {
      const {
        autoFollowPattern: stateFields
      } = this.state;
      const {
        followIndexPatternPrefix,
        followIndexPatternSuffix,
        ...rest
      } = stateFields;
      return {
        ...rest,
        followIndexPattern: `${followIndexPatternPrefix}{{leader_index}}${followIndexPatternSuffix}`
      };
    });
    (0, _defineProperty2.default)(this, "sendForm", () => {
      const isFormValid = this.isFormValid();
      if (!isFormValid) {
        this.setState({
          areErrorsVisible: true
        });
        return;
      }
      this.setState({
        areErrorsVisible: false
      });
      const {
        name,
        ...autoFollowPattern
      } = this.getFields();
      this.props.saveAutoFollowPattern(name, autoFollowPattern);
    });
    (0, _defineProperty2.default)(this, "cancelForm", () => {
      _routing.routing.navigate('/auto_follow_patterns');
    });
    (0, _defineProperty2.default)(this, "renderForm", () => {
      const {
        autoFollowPattern: {
          name,
          remoteCluster,
          leaderIndexPatterns,
          followIndexPatternPrefix,
          followIndexPatternSuffix
        },
        isNew,
        areErrorsVisible,
        fieldsErrors
      } = this.state;

      /**
       * Auto-follow pattern Name
       */
      const renderAutoFollowPatternName = () => {
        const isInvalid = areErrorsVisible && !!fieldsErrors.name;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 278,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("h4", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 279,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternNameTitle",
            defaultMessage: "Name",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 280,
              columnNumber: 17
            }
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternNameDescription",
            defaultMessage: "A unique name for the auto-follow pattern.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 288,
              columnNumber: 13
            }
          }),
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 276,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.autoFollowPatternName.fieldNameLabel",
            defaultMessage: "Name",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 297,
              columnNumber: 15
            }
          }),
          error: fieldsErrors.name,
          isInvalid: isInvalid,
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 295,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isInvalid,
          value: name,
          onChange: e => this.onFieldsChange({
            name: e.target.value
          }),
          fullWidth: true,
          disabled: !isNew,
          "data-test-subj": "nameInput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 306,
            columnNumber: 13
          }
        })));
      };

      /**
       * Remote Cluster
       */
      const renderRemoteClusterField = () => {
        const {
          remoteClusters,
          currentUrl
        } = this.props;
        const errorMessages = {
          noClusterFound: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.emptyRemoteClustersCallOutDescription",
            defaultMessage: "Auto-follow patterns capture indices on remote clusters.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 327,
              columnNumber: 11
            }
          }),
          remoteClusterNotConnectedNotEditable: name => ({
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.autoFollowPatternForm.currentRemoteClusterNotConnectedCallOutTitle",
              defaultMessage: "Can't edit auto-follow pattern because remote cluster ''{name}'' is not connected",
              values: {
                name
              },
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 334,
                columnNumber: 13
              }
            }),
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.autoFollowPatternForm.currentRemoteClusterNotConnectedCallOutDescription",
              defaultMessage: "You can address this by editing the remote cluster.",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 341,
                columnNumber: 13
              }
            })
          }),
          remoteClusterDoesNotExist: name => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.currentRemoteClusterNotFoundCallOutDescription",
            defaultMessage: "To edit this auto-follow pattern, you must add a remote cluster named ''{name}''.",
            values: {
              name
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 348,
              columnNumber: 11
            }
          })
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 360,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("h4", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 361,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionRemoteClusterTitle",
            defaultMessage: "Remote cluster",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 362,
              columnNumber: 17
            }
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionRemoteClusterDescription",
            defaultMessage: "The remote cluster to replicate leader indices from.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 370,
              columnNumber: 13
            }
          }),
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 358,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_remote_clusters_form_field.RemoteClustersFormField, {
          selected: remoteCluster ? remoteCluster : null,
          remoteClusters: remoteClusters,
          currentUrl: currentUrl,
          isEditable: isNew,
          areErrorsVisible: areErrorsVisible,
          onChange: this.onClusterChange,
          onError: error => this.onFieldsErrorChange({
            remoteCluster: error
          }),
          errorMessages: errorMessages,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 377,
            columnNumber: 11
          }
        }));
      };

      /**
       * Leader index pattern(s)
       */
      const renderLeaderIndexPatterns = () => {
        const hasError = !!(fieldsErrors.leaderIndexPatterns && fieldsErrors.leaderIndexPatterns.message);
        const isInvalid = hasError && (fieldsErrors.leaderIndexPatterns.alwaysVisible || areErrorsVisible);
        const formattedLeaderIndexPatterns = leaderIndexPatterns.map(pattern => ({
          label: pattern
        }));
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 407,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("h4", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 408,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsTitle",
            defaultMessage: "Leader indices",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 409,
              columnNumber: 17
            }
          }))),
          description: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 417,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 418,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsDescription1",
            defaultMessage: "One or more index patterns that identify the indices you want to replicate from the remote cluster. As new indices matching these patterns are created, they are replicated to follower indices on the local cluster.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 419,
              columnNumber: 17
            }
          })), /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 427,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsDescription2",
            defaultMessage: "{note} Indices that already exist are not replicated.",
            values: {
              note: /*#__PURE__*/_react.default.createElement("strong", {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 433,
                  columnNumber: 23
                }
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsDescription2.noteLabel",
                defaultMessage: "Note:",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 434,
                  columnNumber: 25
                }
              }))
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 428,
              columnNumber: 17
            }
          }))),
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 405,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.fieldLeaderIndexPatternsLabel",
            defaultMessage: "Index patterns",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 449,
              columnNumber: 15
            }
          }),
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.fieldLeaderIndexPatternsHelpLabel",
            defaultMessage: "Spaces and the characters {characterList} are not allowed.",
            values: {
              characterList: /*#__PURE__*/_react.default.createElement("strong", {
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 458,
                  columnNumber: 42
                }
              }, indexPatternIllegalCharacters)
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 455,
              columnNumber: 15
            }
          }),
          isInvalid: isInvalid,
          error: fieldsErrors.leaderIndexPatterns && fieldsErrors.leaderIndexPatterns.message,
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 447,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
          isInvalid: isInvalid,
          noSuggestions: true,
          placeholder: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.fieldLeaderIndexPatternsPlaceholder', {
            defaultMessage: 'Type and then hit ENTER'
          }),
          selectedOptions: formattedLeaderIndexPatterns,
          onCreateOption: this.onCreateLeaderIndexPattern,
          onChange: this.onLeaderIndexPatternChange,
          onSearchChange: this.onLeaderIndexPatternInputChange,
          fullWidth: true,
          "data-test-subj": "indexPatternInput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 465,
            columnNumber: 13
          }
        })));
      };

      /**
       * Auto-follow pattern prefix/suffix
       */
      const renderAutoFollowPatternPrefixSuffix = () => {
        const isPrefixInvalid = areErrorsVisible && !!fieldsErrors.followIndexPatternPrefix;
        const isSuffixInvalid = areErrorsVisible && !!fieldsErrors.followIndexPatternSuffix;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 496,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("h4", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 497,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternTitle",
            defaultMessage: "Follower indices (optional)",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 498,
              columnNumber: 17
            }
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternDescription",
            defaultMessage: "A custom prefix or suffix to apply to the names of the follower indices so you can more easily identify replicated indices. By default, a follower index has the same name as the leader index.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 506,
              columnNumber: 13
            }
          }),
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 494,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 515,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 516,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.autoFollowPattern.fieldPrefixLabel",
            defaultMessage: "Prefix",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 519,
              columnNumber: 19
            }
          }),
          error: fieldsErrors.followIndexPatternPrefix,
          isInvalid: isPrefixInvalid,
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 517,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isPrefixInvalid,
          value: followIndexPatternPrefix,
          onChange: e => this.onFieldsChange({
            followIndexPatternPrefix: e.target.value
          }),
          fullWidth: true,
          "data-test-subj": "prefixInput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 528,
            columnNumber: 17
          }
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 540,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.autoFollowPattern.fieldSuffixLabel",
            defaultMessage: "Suffix",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 543,
              columnNumber: 19
            }
          }),
          error: fieldsErrors.followIndexPatternSuffix,
          isInvalid: isSuffixInvalid,
          fullWidth: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 541,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isSuffixInvalid,
          value: followIndexPatternSuffix,
          onChange: e => this.onFieldsChange({
            followIndexPatternSuffix: e.target.value
          }),
          fullWidth: true,
          "data-test-subj": "suffixInput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 552,
            columnNumber: 17
          }
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 565,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternForm.fieldFollowerIndicesHelpLabel",
          defaultMessage: "Spaces and the characters {characterList} are not allowed.",
          values: {
            characterList: /*#__PURE__*/_react.default.createElement("strong", {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 569,
                columnNumber: 40
              }
            }, indexNameIllegalCharacters)
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 566,
            columnNumber: 13
          }
        })), !!leaderIndexPatterns.length && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 574,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 575,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_auto_follow_pattern_indices_preview.AutoFollowPatternIndicesPreview, {
          prefix: followIndexPatternPrefix,
          suffix: followIndexPatternSuffix,
          leaderIndexPatterns: leaderIndexPatterns,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 576,
            columnNumber: 15
          }
        })));
      };

      /**
       * Form Error warning message
       */
      const renderFormErrorWarning = () => {
        const {
          areErrorsVisible
        } = this.state;
        const isFormValid = this.isFormValid();
        if (!areErrorsVisible || isFormValid) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 599,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          role: "alert",
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.validationErrorTitle",
            defaultMessage: "Fix errors before continuing.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 603,
              columnNumber: 15
            }
          }),
          color: "danger",
          iconType: "cross",
          "data-test-subj": "formError",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 600,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "l",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 612,
            columnNumber: 11
          }
        }));
      };

      /**
       * Form Actions
       */
      const renderActions = () => {
        const {
          apiStatus,
          saveButtonLabel
        } = this.props;
        const {
          areErrorsVisible,
          isRequestVisible
        } = this.state;
        if (apiStatus === _constants.API_STATUS.SAVING) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexStart",
            gutterSize: "m",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 626,
              columnNumber: 11
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 627,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "l",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 628,
              columnNumber: 15
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 631,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 632,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.actions.savingText",
            defaultMessage: "Saving",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 633,
              columnNumber: 17
            }
          }))));
        }
        const isSaveDisabled = areErrorsVisible && !this.isFormValid();
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "spaceBetween",
          alignItems: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 646,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 647,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 648,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "success",
          iconType: "check",
          onClick: this.sendForm,
          fill: true,
          disabled: isSaveDisabled,
          "data-test-subj": "submitButton",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 649,
            columnNumber: 15
          }
        }, saveButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 661,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          color: "primary",
          onClick: this.cancelForm,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 662,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternForm.cancelButtonLabel",
          defaultMessage: "Cancel",
          "data-test-subj": "cancelButton",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 663,
            columnNumber: 17
          }
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 671,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: this.toggleRequest,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 672,
            columnNumber: 13
          }
        }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternForm.hideRequestButtonLabel",
          defaultMessage: "Hide request",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 674,
            columnNumber: 17
          }
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternFormm.showRequestButtonLabel",
          defaultMessage: "Show request",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 679,
            columnNumber: 17
          }
        }))));
      };
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 691,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        "data-test-subj": "autoFollowPatternForm",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 692,
          columnNumber: 9
        }
      }, renderAutoFollowPatternName(), renderRemoteClusterField(), renderLeaderIndexPatterns(), renderAutoFollowPatternPrefixSuffix()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 698,
          columnNumber: 9
        }
      }), renderFormErrorWarning(), this.renderApiErrors(), renderActions());
    });
    (0, _defineProperty2.default)(this, "renderLoading", () => {
      const {
        apiStatus
      } = this.props;
      if (apiStatus === _constants.API_STATUS.SAVING) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 711,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
          logo: "logoKibana",
          size: "xl",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 712,
            columnNumber: 11
          }
        }));
      }
      return null;
    });
    const _isNew = this.props.autoFollowPattern === undefined;
    const {
      route: {
        location: {
          search
        }
      }
    } = _routing.routing.reactRouter;
    const queryParams = (0, _shared_imports.extractQueryParams)(search);
    const remoteClusterName = (0, _get_remote_cluster_name.getRemoteClusterName)(this.props.remoteClusters, queryParams.cluster);
    const _autoFollowPattern = _isNew ? getEmptyAutoFollowPattern(remoteClusterName) : {
      ...this.props.autoFollowPattern
    };
    this.state = {
      autoFollowPattern: _autoFollowPattern,
      fieldsErrors: (0, _auto_follow_pattern_validators.validateAutoFollowPattern)(_autoFollowPattern),
      areErrorsVisible: false,
      isNew: _isNew,
      isRequestVisible: false
    };
  }
  isFormValid() {
    return Object.values(this.state.fieldsErrors).every(error => error === undefined || error === null);
  }
  /**
   * Secctions Renders
   */
  renderApiErrors() {
    const {
      apiError
    } = this.props;
    if (apiError) {
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.savingErrorTitle', {
        defaultMessage: `Can't create auto-follow pattern`
      });
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_section_error.SectionError, {
        title: title,
        error: apiError,
        "data-test-subj": "apiError",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 11
        }
      }));
    }
    return null;
  }
  render() {
    const {
      autoFollowPattern,
      isRequestVisible,
      isNew
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 723,
        columnNumber: 7
      }
    }, this.renderForm(), this.renderLoading(), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_auto_follow_pattern_request_flyout.AutoFollowPatternRequestFlyout, {
      name: autoFollowPattern.name,
      autoFollowPattern: this.getFields(),
      isNew: isNew,
      close: () => this.setState({
        isRequestVisible: false
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 728,
        columnNumber: 11
      }
    }) : null);
  }
}
exports.AutoFollowPatternForm = AutoFollowPatternForm;
(0, _defineProperty2.default)(AutoFollowPatternForm, "propTypes", {
  saveAutoFollowPattern: _propTypes.default.func.isRequired,
  autoFollowPattern: _propTypes.default.object,
  apiError: _propTypes.default.object,
  apiStatus: _propTypes.default.string.isRequired,
  currentUrl: _propTypes.default.string.isRequired,
  remoteClusters: _propTypes.default.array,
  saveButtonLabel: _propTypes.default.node
});