"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rateLimiterInterceptor = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MAX_ATTEMPTS = 3;
const rateLimiterInterceptor = exports.rateLimiterInterceptor = {
  async fetch(next, options, controller) {
    for (let attempt = 1;; attempt++) {
      try {
        return await next(options);
      } catch (error) {
        if (attempt >= MAX_ATTEMPTS || !(0, _utils.isRateLimiterError)(error)) {
          throw error;
        }
        await new Promise(resolve => setTimeout(resolve, (0, _utils.getRetryAfter)(error) * 1000));
        if (controller.halted) {
          throw error;
        }
      }
    }
  }
};