"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchConnectorById = exports.FetchConnectorByIdApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchConnectorById = async ({
  connectorId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}`;
  const response = await (http === null || http === void 0 ? void 0 : http.get(route));
  return response;
};
exports.fetchConnectorById = fetchConnectorById;
const FetchConnectorByIdApiLogic = exports.FetchConnectorByIdApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_connector_by_id_api_logic'], fetchConnectorById);