"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportConfirmModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _contexts = require("../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/main/import_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ImportConfirmModal = ({
  onClose,
  fileContent
}) => {
  const dispatch = (0, _contexts.useEditorActionContext)();
  const {
    services: {
      notifications
    }
  } = (0, _contexts.useServicesContext)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const onConfirmImport = (0, _react.useCallback)(() => {
    // Import the file content
    dispatch({
      type: 'setFileToImport',
      payload: fileContent
    });
    notifications.toasts.addSuccess(_i18n.i18n.translate('console.notification.fileImportedSuccessfully', {
      defaultMessage: `The file you selected has been imported successfully.`
    }));
    onClose();
  }, [fileContent, onClose, dispatch, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "importConfirmModal",
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('console.importConfirmModal.title', {
      defaultMessage: 'Import and replace requests?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: onClose,
    onConfirm: onConfirmImport,
    cancelButtonText: _i18n.i18n.translate('console.importConfirmModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('console.importConfirmModal.confirmButton', {
      defaultMessage: 'Import and replace'
    }),
    buttonColor: "primary",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('console.importConfirmModal.body', {
    defaultMessage: `Importing this file will replace all current requests in the editor.`
  })));
};
exports.ImportConfirmModal = ImportConfirmModal;