"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCases = exports.initialData = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("./constants");
var _kibana = require("../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("./api");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _use_available_owners = require("../components/app/use_available_owners");
var _permissions = require("../utils/permissions");
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialData = exports.initialData = {
  cases: [],
  countClosedCases: 0,
  countInProgressCases: 0,
  countOpenCases: 0,
  page: 0,
  perPage: 0,
  total: 0
};
const useGetCases = (params = {}) => {
  var _params$filterOptions, _params$filterOptions2, _params$filterOptions3;
  const toasts = (0, _kibana.useToasts)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const availableSolutions = (0, _use_available_owners.useAvailableCasesOwners)((0, _permissions.getAllPermissionsExceptFrom)('delete'));
  const hasOwner = !!owner.length;
  const initialOwner = hasOwner ? owner : availableSolutions;
  const ownerFilter = ((_params$filterOptions = params.filterOptions) === null || _params$filterOptions === void 0 ? void 0 : _params$filterOptions.owner) != null && params.filterOptions.owner.length > 0 ? {
    owner: params.filterOptions.owner
  } : {
    owner: initialOwner
  };

  // overrides for incremental_id search
  const overrides = (0, _utils.getIncrementalIdSearchOverrides)((_params$filterOptions2 = (_params$filterOptions3 = params.filterOptions) === null || _params$filterOptions3 === void 0 ? void 0 : _params$filterOptions3.search) !== null && _params$filterOptions2 !== void 0 ? _params$filterOptions2 : '');
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.cases(params), ({
    signal
  }) => {
    var _params$filterOptions4, _params$queryParams;
    return (0, _api.getCases)({
      filterOptions: {
        ..._constants.DEFAULT_FILTER_OPTIONS,
        ...((_params$filterOptions4 = params.filterOptions) !== null && _params$filterOptions4 !== void 0 ? _params$filterOptions4 : {}),
        ...ownerFilter,
        ...overrides
      },
      queryParams: {
        ..._constants.DEFAULT_QUERY_PARAMS,
        ...((_params$queryParams = params.queryParams) !== null && _params$queryParams !== void 0 ? _params$queryParams : {})
      },
      signal
    });
  }, {
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.ERROR_TITLE
        });
      }
    }
  });
};
exports.useGetCases = useGetCases;