"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openModal = openModal;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _action_wrapper = require("./action_wrapper");
var _utils = require("./utils");
var _use_cases_add_to_existing_case_modal = require("../../all_cases/selector_modal/use_cases_add_to_existing_case_modal");
var _convert_to_absolute_time_range = require("./convert_to_absolute_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/visualizations/actions/open_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddExistingCaseModalWrapper = ({
  lensApi,
  onClose,
  onSuccess
}) => {
  var _lensApi$parentApi;
  const modal = (0, _use_cases_add_to_existing_case_modal.useCasesAddToExistingCaseModal)({
    onClose,
    onSuccess
  });
  const timeRange = (0, _presentationPublishing.useStateFromPublishingSubject)(lensApi.timeRange$);
  const parentTimeRange = (0, _presentationPublishing.useStateFromPublishingSubject)((0, _presentationPublishing.apiPublishesTimeRange)(lensApi.parentApi) ? (_lensApi$parentApi = lensApi.parentApi) === null || _lensApi$parentApi === void 0 ? void 0 : _lensApi$parentApi.timeRange$ : new _rxjs.BehaviorSubject(undefined));
  const absoluteTimeRange = (0, _convert_to_absolute_time_range.convertToAbsoluteTimeRange)(timeRange);
  const absoluteParentTimeRange = (0, _convert_to_absolute_time_range.convertToAbsoluteTimeRange)(parentTimeRange);
  const attachments = (0, _react.useMemo)(() => {
    const appliedTimeRange = absoluteTimeRange !== null && absoluteTimeRange !== void 0 ? absoluteTimeRange : absoluteParentTimeRange;
    const attributes = lensApi.getFullAttributes();
    return !attributes || !appliedTimeRange ? [] : [(0, _utils.getLensCaseAttachment)({
      attributes,
      timeRange: appliedTimeRange
    })];
  }, [lensApi, absoluteTimeRange, absoluteParentTimeRange]);
  (0, _react.useEffect)(() => {
    modal.open({
      getAttachments: () => attachments
    });
  }, [attachments, modal]);
  return null;
};
AddExistingCaseModalWrapper.displayName = 'AddExistingCaseModalWrapper';
function openModal(lensApi, currentAppId, casesActionContextProps, services) {
  const targetDomElement = document.createElement('div');
  const cleanupDom = shouldCleanup => {
    if (targetDomElement != null && shouldCleanup) {
      (0, _reactDom.unmountComponentAtNode)(targetDomElement);
    }
  };
  const onClose = (theCase, isCreateCase) => {
    const closeModalClickedScenario = theCase == null && !isCreateCase;
    const caseSelectedScenario = theCase != null;
    // When `Creating` a case from the `add to existing case modal`,
    // we close the modal and then open the flyout.
    // If we clean up dom when closing the modal, then the flyout won't open.
    // Thus we do not clean up dom when `Creating` a case.
    const shouldCleanup = closeModalClickedScenario || caseSelectedScenario;
    cleanupDom(shouldCleanup);
  };
  const onSuccess = () => {
    cleanupDom(true);
  };
  const mount = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_action_wrapper.ActionWrapper, {
    casesActionContextProps: casesActionContextProps,
    currentAppId: currentAppId,
    services: services,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AddExistingCaseModalWrapper, {
    lensApi: lensApi,
    onClose: onClose,
    onSuccess: onSuccess,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  })), services.core);
  mount(targetDomElement);
}