"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _prettyMs = _interopRequireDefault(require("pretty-ms"));
var _domain = require("../../../common/types/domain");
var _status_stats = require("../status/status_stats");
var _use_get_cases_metrics = require("../../containers/use_get_cases_metrics");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/cases_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CasesMetrics = () => {
  var _status$open, _status$inProgress, _status$closed;
  const {
    data: {
      mttr,
      status
    } = {
      mttr: 0
    },
    isLoading: isCasesMetricsLoading
  } = (0, _use_get_cases_metrics.useGetCasesMetrics)();
  const mttrValue = (0, _react.useMemo)(() => mttr != null ? (0, _prettyMs.default)(mttr * 1000, {
    compact: true,
    verbose: false
  }) : '-', [mttr]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    "data-test-subj": "cases-metrics-stats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "openStatsHeader",
    caseCount: (_status$open = status === null || status === void 0 ? void 0 : status.open) !== null && _status$open !== void 0 ? _status$open : 0,
    caseStatus: _domain.CaseStatuses.open,
    isLoading: isCasesMetricsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "inProgressStatsHeader",
    caseCount: (_status$inProgress = status === null || status === void 0 ? void 0 : status.inProgress) !== null && _status$inProgress !== void 0 ? _status$inProgress : 0,
    caseStatus: _domain.CaseStatuses['in-progress'],
    isLoading: isCasesMetricsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_status_stats.StatusStats, {
    dataTestSubj: "closedStatsHeader",
    caseCount: (_status$closed = status === null || status === void 0 ? void 0 : status.closed) !== null && _status$closed !== void 0 ? _status$closed : 0,
    caseStatus: _domain.CaseStatuses.closed,
    isLoading: isCasesMetricsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": 'mttrStatsHeader',
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.ATTC_STAT, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _translations.ATTC_DESCRIPTION,
      position: "right",
      "aria-label": _translations.ATTC_STAT_INFO_ARIA_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    })),
    title: isCasesMetricsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": `mttr-stat-loading-spinner`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 19
      }
    }) : mttrValue,
    titleSize: "xs",
    "text-align": "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }));
};
exports.CasesMetrics = CasesMetrics;
CasesMetrics.displayName = 'CasesMetrics';