"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toolbar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _page_manager = require("../page_manager");
var _expression = require("../expression");
var _tray = require("./tray");
var _routing = require("../routing");
var _workpad = require("../../routes/workpad");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/toolbar/toolbar.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getEditorButtonLabel: () => _i18n.i18n.translate('xpack.canvas.toolbar.editorButtonLabel', {
    defaultMessage: 'Expression editor'
  }),
  getNextPageAriaLabel: () => _i18n.i18n.translate('xpack.canvas.toolbar.nextPageAriaLabel', {
    defaultMessage: 'Next Page'
  }),
  getPageButtonLabel: (pageNum, totalPages) => _i18n.i18n.translate('xpack.canvas.toolbar.pageButtonLabel', {
    defaultMessage: 'Page {pageNum}{rest}',
    values: {
      pageNum,
      rest: totalPages > 1 ? ` of ${totalPages}` : ''
    }
  }),
  getPreviousPageAriaLabel: () => _i18n.i18n.translate('xpack.canvas.toolbar.previousPageAriaLabel', {
    defaultMessage: 'Previous Page'
  })
};
const Toolbar = ({
  isWriteable,
  selectedElement,
  selectedPageNumber,
  totalPages,
  workpadName
}) => {
  const [activeTray, setActiveTray] = (0, _react.useState)(null);
  const {
    getUrl,
    previousPage
  } = (0, _react.useContext)(_workpad.WorkpadRoutingContext);

  // While the tray doesn't get activated if the workpad isn't writeable,
  // this effect will ensure that if the tray is open and the workpad
  // changes its writeable state, the tray will close.
  (0, _react.useEffect)(() => {
    if (!isWriteable && activeTray === 'expression') {
      setActiveTray(null);
    }
  }, [isWriteable, activeTray]);
  const elementIsSelected = Boolean(selectedElement);
  const toggleTray = tray => {
    if (activeTray === tray) {
      setActiveTray(null);
    } else {
      if (!isWriteable && tray === 'expression') {
        return;
      }
      setActiveTray(tray);
    }
  };
  const trays = {
    pageManager: /*#__PURE__*/_react.default.createElement(_page_manager.PageManager, {
      onPreviousPage: previousPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 18
      }
    }),
    expression: !elementIsSelected ? null : /*#__PURE__*/_react.default.createElement(_expression.Expression, {
      done: () => setActiveTray(null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 45
      }
    })
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasToolbar hide-for-sharing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, activeTray !== null && /*#__PURE__*/_react.default.createElement(_tray.Tray, {
    done: () => setActiveTray(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 31
    }
  }, trays[activeTray]), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasToolbar__container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "canvasToolbar__home",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, workpadName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    className: "canvasToolbar__controls",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_routing.RoutingButtonIcon, {
    color: "text",
    to: getUrl(selectedPageNumber - 1),
    iconType: "arrowLeft",
    isDisabled: selectedPageNumber <= 1,
    "aria-label": strings.getPreviousPageAriaLabel(),
    "data-test-subj": "previousPageButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: () => toggleTray('pageManager'),
    "data-test-subj": "canvasPageManagerButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  }, strings.getPageButtonLabel(selectedPageNumber, totalPages))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_routing.RoutingButtonIcon, {
    color: "text",
    to: getUrl(selectedPageNumber + 1),
    iconType: "arrowRight",
    isDisabled: selectedPageNumber >= totalPages,
    "aria-label": strings.getNextPageAriaLabel(),
    "data-test-subj": "nextPageButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }), elementIsSelected && isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconType: "editorCodeBlock",
    onClick: () => toggleTray('expression'),
    "data-test-subj": "canvasExpressionEditorButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }, strings.getEditorButtonLabel())))))));
};
exports.Toolbar = Toolbar;
Toolbar.propTypes = {
  isWriteable: _propTypes.default.bool.isRequired,
  selectedElement: _propTypes.default.object,
  selectedPageNumber: _propTypes.default.number.isRequired,
  totalPages: _propTypes.default.number.isRequired,
  workpadName: _propTypes.default.string.isRequired
};