"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKVGraph = getKVGraph;
var _langgraph = require("@langchain/langgraph");
var _kv = require("./kv");
var _header = require("./header");
var _error = require("./error");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  logSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  kvLogMessages: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  jsonSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  header: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  errors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  kvProcessor: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({
      kv: {}
    })
  },
  grokPattern: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  additionalProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  ecsVersion: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  }
};
function modelInput({
  state
}) {
  return {
    finalized: false,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput({
  state
}) {
  return {
    finalized: true,
    additionalProcessors: state.additionalProcessors,
    lastExecutedChain: 'modelOutput'
  };
}
function headerRouter({
  state
}) {
  if (state.header === true) {
    return 'header';
  }
  return 'noHeader';
}
function kvRouter({
  state
}) {
  if (Object.keys(state.errors).length === 0) {
    return 'modelOutput';
  }
  return 'handleKVError';
}
function kvHeaderRouter({
  state
}) {
  if (Object.keys(state.errors).length === 0) {
    return 'handleKV';
  }
  return 'handleHeaderError';
}
async function getKVGraph({
  model,
  client
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addNode('handleHeader', state => (0, _header.handleHeader)({
    state,
    model,
    client
  })).addNode('handleKVError', state => (0, _error.handleKVError)({
    state,
    model,
    client
  })).addNode('handleHeaderError', state => (0, _error.handleHeaderError)({
    state,
    model,
    client
  })).addNode('handleKV', state => (0, _kv.handleKV)({
    state,
    model,
    client
  })).addNode('handleKVValidate', state => (0, _validate.handleKVValidate)({
    state,
    model,
    client
  })).addNode('handleHeaderValidate', state => (0, _validate.handleHeaderValidate)({
    state,
    model,
    client
  })).addEdge(_langgraph.START, 'modelInput').addConditionalEdges('modelInput', state => headerRouter({
    state
  }), {
    header: 'handleHeader',
    noHeader: 'handleKV'
  }).addEdge('handleHeader', 'handleHeaderValidate').addConditionalEdges('handleHeaderValidate', state => kvHeaderRouter({
    state
  }), {
    handleHeaderError: 'handleHeaderError',
    handleKV: 'handleKV'
  }).addEdge('handleHeaderError', 'handleHeaderValidate').addEdge('handleKVError', 'handleKVValidate').addEdge('handleKV', 'handleKVValidate').addConditionalEdges('handleKVValidate', state => kvRouter({
    state
  }), {
    handleKVError: 'handleKVError',
    modelOutput: 'modelOutput'
  }).addEdge('modelOutput', _langgraph.END);
  const compiledKVGraph = workflow.compile();
  return compiledKVGraph;
}