"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _buttons_footer = require("../../../../common/components/buttons_footer");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/footer/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Generation button for Step 3
const AnalyzeButtonText = /*#__PURE__*/_react.default.memo(({
  isGenerating
}) => {
  if (!isGenerating) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ANALYZE_LOGS);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "generatingLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }), i18n.LOADING);
});
AnalyzeButtonText.displayName = 'AnalyzeButtonText';
const Footer = exports.Footer = /*#__PURE__*/_react.default.memo(({
  isGenerating = false,
  isAnalyzeStep = false,
  isLastStep = false,
  isNextStepEnabled = false,
  isNextAddingToElastic = false,
  onBack = () => {},
  onNext = () => {}
}) => {
  const nextButtonText = (0, _react.useMemo)(() => isNextAddingToElastic ? i18n.ADD_TO_ELASTIC : isAnalyzeStep ? /*#__PURE__*/_react.default.createElement(AnalyzeButtonText, {
    isGenerating: isGenerating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }) : null, [isNextAddingToElastic, isAnalyzeStep, isGenerating]);
  return isLastStep ? /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    cancelButtonText: i18n.CLOSE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    nextButtonText: nextButtonText,
    isNextDisabled: !isNextStepEnabled,
    onBack: onBack,
    onNext: onNext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  });
});
Footer.displayName = 'Footer';