"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMAlertingLatencyChart = APMAlertingLatencyChart;
var _react = _interopRequireDefault(require("react"));
var _latency_chart = _interopRequireDefault(require("../../../components/alerting/ui_components/alert_details_app_section/latency_chart"));
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _use_alerting_props = require("../use_alerting_props");
var _time_range_callout = require("../time_range_callout");
var _service_name_callout = require("../service_name_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/embeddable/alerting/alerting_latency_chart/chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function APMAlertingLatencyChart({
  rule,
  alert,
  serviceName,
  environment = _environment_filter_values.ENVIRONMENT_ALL.value,
  transactionType,
  transactionName,
  rangeFrom = 'now-15m',
  rangeTo = 'now',
  latencyThresholdInMicroseconds,
  kuery = '',
  filters
}) {
  const {
    transactionType: currentTransactionType,
    transactionTypes,
    setTransactionType,
    comparisonChartTheme,
    latencyAggregationType,
    setLatencyAggregationType,
    timeZone
  } = (0, _use_alerting_props.useAlertingProps)({
    rule,
    rangeFrom,
    rangeTo,
    kuery,
    serviceName,
    defaultTransactionType: transactionType
  });
  if (!rangeFrom || !rangeTo) {
    return /*#__PURE__*/_react.default.createElement(_time_range_callout.TimeRangeCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  }
  if (!serviceName || !currentTransactionType) {
    return /*#__PURE__*/_react.default.createElement(_service_name_callout.ServiceNameCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_latency_chart.default, {
    alert: alert,
    transactionType: currentTransactionType,
    transactionTypes: transactionTypes,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: rangeFrom,
    end: rangeTo,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    latencyAggregationType: latencyAggregationType,
    setLatencyAggregationType: setLatencyAggregationType,
    setTransactionType: setTransactionType,
    comparisonEnabled: false,
    offset: '',
    customAlertEvaluationThreshold: latencyThresholdInMicroseconds,
    kuery: kuery,
    filters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
}