"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOGGLE_BUTTON_WIDTH = void 0;
exports.ToggleAccordionButton = ToggleAccordionButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatters = require("../../../../common/utils/formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/toggle_accordion_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TOGGLE_BUTTON_WIDTH = exports.TOGGLE_BUTTON_WIDTH = 20;
function ToggleAccordionButton({
  isOpen,
  childrenCount,
  onClick
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    responsive: false,
    css: {
      position: 'relative',
      width: `${TOGGLE_BUTTON_WIDTH}px`
    },
    "data-test-subj": "toggleAccordionButton",
    onClick: onClick,
    onKeyDown: e => {
      if (onClick && (e.key === 'Enter' || e.key === ' ')) {
        e.preventDefault(); // Prevent scroll if Space is pressed
        onClick();
      }
    },
    tabIndex: 0,
    role: "button",
    "aria-label": _i18n.i18n.translate('xpack.apm.toggleAccordionButton', {
      defaultMessage: 'Toggle accordion'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isOpen ? 'arrowDown' : 'arrowRight',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      top: '50%',
      transform: 'translate(0, -50%)'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: childrenCount,
    delay: "long",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, (0, _formatters.asBigNumber)(childrenCount))))));
}