"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMockMaintenanceWindow = void 0;
var _rrule = require("@kbn/rrule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMockMaintenanceWindow = overwrites => {
  return {
    title: 'test-title',
    duration: 60 * 60 * 1000,
    enabled: true,
    rRule: {
      tzid: 'UTC',
      dtstart: '2023-02-26T00:00:00.000Z',
      freq: _rrule.Frequency.WEEKLY,
      count: 2
    },
    events: [{
      gte: '2023-02-26T00:00:00.000Z',
      lte: '2023-02-26T01:00:00.000Z'
    }, {
      gte: '2023-03-05T00:00:00.000Z',
      lte: '2023-03-05T01:00:00.000Z'
    }],
    createdAt: '2023-02-26T00:00:00.000Z',
    updatedAt: '2023-02-26T00:00:00.000Z',
    createdBy: 'test-user',
    updatedBy: 'test-user',
    expirationDate: new Date().toISOString(),
    ...overwrites
  };
};
exports.getMockMaintenanceWindow = getMockMaintenanceWindow;