"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMaintenanceWindowParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _r_rule = require("../../../../../../common/routes/r_rule");
var _schemas = require("../../../schemas");
var _schemas2 = require("../../../../alerts_filter_query/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMaintenanceWindowParamsSchema = exports.createMaintenanceWindowParamsSchema = _configSchema.schema.object({
  data: _configSchema.schema.object({
    title: _configSchema.schema.string(),
    duration: _configSchema.schema.number(),
    rRule: _r_rule.rRuleRequestSchema,
    categoryIds: _schemas.maintenanceWindowCategoryIdsSchema,
    scopedQuery: _configSchema.schema.maybe(_configSchema.schema.nullable(_schemas2.alertsFilterQuerySchema)),
    enabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: true
    }))
  })
});