"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.histogramHandlerFactory = void 0;
var _lodash = require("lodash");
var _async = require("async");
var _i18n = require("@kbn/i18n");
var _queue_field_candidates = require("@kbn/aiops-log-rate-analysis/queue_field_candidates");
var _stream_reducer = require("@kbn/aiops-log-rate-analysis/api/stream_reducer");
var _fetch_mini_histograms_for_significant_items = require("@kbn/aiops-log-rate-analysis/queries/fetch_mini_histograms_for_significant_items");
var _constants = require("../response_stream_utils/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const histogramHandlerFactory = ({
  abortSignal,
  esClient,
  logDebugMessage,
  logger,
  requestBody,
  responseStream,
  stateHandler
}) => async (fieldValuePairsCount, significantCategories, significantTerms, overallTimeSeries) => {
  var _requestBody$override;
  function pushHistogramDataLoadingState() {
    responseStream.push((0, _stream_reducer.updateLoadingState)({
      ccsWarning: false,
      loaded: stateHandler.loaded(),
      loadingState: _i18n.i18n.translate('xpack.aiops.logRateAnalysis.loadingState.loadingHistogramData', {
        defaultMessage: 'Loading histogram data.'
      })
    }));
  }
  logDebugMessage(`Fetch ${significantTerms.length} field/value histograms.`);

  // time series filtered by fields
  if ((significantTerms.length > 0 || significantCategories.length > 0) && overallTimeSeries !== undefined && !((_requestBody$override = requestBody.overrides) !== null && _requestBody$override !== void 0 && _requestBody$override.regroupOnly)) {
    const fieldValueHistogramQueueChunks = [...(0, _lodash.chunk)(significantTerms, _queue_field_candidates.QUEUE_CHUNKING_SIZE), ...(0, _lodash.chunk)(significantCategories, _queue_field_candidates.QUEUE_CHUNKING_SIZE)];
    const loadingStepSize = 1 / fieldValueHistogramQueueChunks.length * _constants.PROGRESS_STEP_HISTOGRAMS;
    const fieldValueHistogramQueue = (0, _async.queue)(async function (payload) {
      if (stateHandler.shouldStop()) {
        logDebugMessage('shouldStop abort fetching field/value histograms.');
        fieldValueHistogramQueue.kill();
        responseStream.end();
        return;
      }
      if (overallTimeSeries !== undefined) {
        let histograms;
        try {
          histograms = await (0, _fetch_mini_histograms_for_significant_items.fetchMiniHistogramsForSignificantItems)(esClient, requestBody, payload, overallTimeSeries, logger, stateHandler.sampleProbability(), () => {}, abortSignal);
        } catch (e) {
          logger.error(`Failed to fetch the histogram data chunk, got: \n${e.toString()}`);
          responseStream.pushError(`Failed to fetch the histogram data chunk.`);
          return;
        }
        stateHandler.loaded(loadingStepSize, false);
        pushHistogramDataLoadingState();
        responseStream.push((0, _stream_reducer.addSignificantItemsHistogram)(histograms));
      }
    }, _constants.MAX_CONCURRENT_QUERIES);
    await fieldValueHistogramQueue.push(fieldValueHistogramQueueChunks);
    await fieldValueHistogramQueue.drain();
  }
};
exports.histogramHandlerFactory = histogramHandlerFactory;